<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for company StructType
 * @subpackage Structs
 */
class Company extends AbstractStructBase
{
    /**
     * The registeredOffice
     * Meta informations extracted from the WSDL
     * - documentation: if set returns Registered Office of the company
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $registeredOffice;
    /**
     * The principalPlaceOfBusiness
     * Meta informations extracted from the WSDL
     * - documentation: if set returns the Principal Place Of Business of the company
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $principalPlaceOfBusiness;
    /**
     * The officeholders
     * Meta informations extracted from the WSDL
     * - documentation: if set returns the Directors, Secretaries and Alternate Drictors of the company
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $officeholders;
    /**
     * The shareHolders
     * Meta informations extracted from the WSDL
     * - documentation: if set returns Share Holders of the company
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $shareHolders;
    /**
     * Constructor method for company
     * @uses Company::setRegisteredOffice()
     * @uses Company::setPrincipalPlaceOfBusiness()
     * @uses Company::setOfficeholders()
     * @uses Company::setShareHolders()
     * @param bool $registeredOffice
     * @param bool $principalPlaceOfBusiness
     * @param bool $officeholders
     * @param bool $shareHolders
     */
    public function __construct($registeredOffice = null, $principalPlaceOfBusiness = null, $officeholders = null, $shareHolders = null)
    {
        $this
            ->setRegisteredOffice($registeredOffice)
            ->setPrincipalPlaceOfBusiness($principalPlaceOfBusiness)
            ->setOfficeholders($officeholders)
            ->setShareHolders($shareHolders);
    }
    /**
     * Get registeredOffice value
     * @return bool|null
     */
    public function getRegisteredOffice()
    {
        return $this->registeredOffice;
    }
    /**
     * Set registeredOffice value
     * @param bool $registeredOffice
     * @return \StructType\Company
     */
    public function setRegisteredOffice($registeredOffice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($registeredOffice) && !preg_match('/true/', $registeredOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($registeredOffice, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($registeredOffice) && !is_bool($registeredOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($registeredOffice)), __LINE__);
        }
        $this->registeredOffice = $registeredOffice;
        return $this;
    }
    /**
     * Get principalPlaceOfBusiness value
     * @return bool|null
     */
    public function getPrincipalPlaceOfBusiness()
    {
        return $this->principalPlaceOfBusiness;
    }
    /**
     * Set principalPlaceOfBusiness value
     * @param bool $principalPlaceOfBusiness
     * @return \StructType\Company
     */
    public function setPrincipalPlaceOfBusiness($principalPlaceOfBusiness = null)
    {
        // validation for constraint: pattern
        if (is_scalar($principalPlaceOfBusiness) && !preg_match('/true/', $principalPlaceOfBusiness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($principalPlaceOfBusiness, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($principalPlaceOfBusiness) && !is_bool($principalPlaceOfBusiness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($principalPlaceOfBusiness)), __LINE__);
        }
        $this->principalPlaceOfBusiness = $principalPlaceOfBusiness;
        return $this;
    }
    /**
     * Get officeholders value
     * @return bool|null
     */
    public function getOfficeholders()
    {
        return $this->officeholders;
    }
    /**
     * Set officeholders value
     * @param bool $officeholders
     * @return \StructType\Company
     */
    public function setOfficeholders($officeholders = null)
    {
        // validation for constraint: pattern
        if (is_scalar($officeholders) && !preg_match('/true/', $officeholders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($officeholders, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($officeholders) && !is_bool($officeholders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($officeholders)), __LINE__);
        }
        $this->officeholders = $officeholders;
        return $this;
    }
    /**
     * Get shareHolders value
     * @return bool|null
     */
    public function getShareHolders()
    {
        return $this->shareHolders;
    }
    /**
     * Set shareHolders value
     * @param bool $shareHolders
     * @return \StructType\Company
     */
    public function setShareHolders($shareHolders = null)
    {
        // validation for constraint: pattern
        if (is_scalar($shareHolders) && !preg_match('/true/', $shareHolders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($shareHolders, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($shareHolders) && !is_bool($shareHolders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($shareHolders)), __LINE__);
        }
        $this->shareHolders = $shareHolders;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Company
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
