<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for charge StructType
 * @subpackage Structs
 */
class Charge extends AbstractStructBase
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - maxLength: 5
     * @var string
     */
    public $code;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxLength: 80
     * @var string
     */
    public $description;
    /**
     * The historical
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $historical;
    /**
     * The large
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $large;
    /**
     * Constructor method for charge
     * @uses Charge::setCode()
     * @uses Charge::setDescription()
     * @uses Charge::setHistorical()
     * @uses Charge::setLarge()
     * @param string $code
     * @param string $description
     * @param bool $historical
     * @param bool $large
     */
    public function __construct($code = null, $description = null, $historical = null, $large = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setHistorical($historical)
            ->setLarge($large);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Charge
     */
    public function setCode($code = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($code) && strlen($code) > 5) || (is_array($code) && count($code) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($code) ? strlen($code) : count($code)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Charge
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 80) || (is_array($description) && count($description) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get historical value
     * @return bool|null
     */
    public function getHistorical()
    {
        return $this->historical;
    }
    /**
     * Set historical value
     * @param bool $historical
     * @return \StructType\Charge
     */
    public function setHistorical($historical = null)
    {
        // validation for constraint: boolean
        if (!is_null($historical) && !is_bool($historical)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($historical)), __LINE__);
        }
        $this->historical = $historical;
        return $this;
    }
    /**
     * Get large value
     * @return bool|null
     */
    public function getLarge()
    {
        return $this->large;
    }
    /**
     * Set large value
     * @param bool $large
     * @return \StructType\Charge
     */
    public function setLarge($large = null)
    {
        // validation for constraint: boolean
        if (!is_null($large) && !is_bool($large)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($large)), __LINE__);
        }
        $this->large = $large;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Charge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
