<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for businessType StructType
 * @subpackage Structs
 */
class BusinessType extends AbstractStructBase
{
    /**
     * The abrEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AbrEntityType
     */
    public $abrEntity;
    /**
     * The organisation
     * Meta informations extracted from the WSDL
     * - documentation: CompanyPartnershipUnincorporateStructure
     * @var \StructType\BaseNniEntityType
     */
    public $organisation;
    /**
     * The individual
     * Meta informations extracted from the WSDL
     * - documentation: Sole TraderIndividual
     * @var \StructType\IndividualType
     */
    public $individual;
    /**
     * The businessName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\OutboundBusinessNameType[]
     */
    public $businessName;
    /**
     * The agent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AgentType
     */
    public $agent;
    /**
     * Constructor method for businessType
     * @uses BusinessType::setAbrEntity()
     * @uses BusinessType::setOrganisation()
     * @uses BusinessType::setIndividual()
     * @uses BusinessType::setBusinessName()
     * @uses BusinessType::setAgent()
     * @param \StructType\AbrEntityType $abrEntity
     * @param \StructType\BaseNniEntityType $organisation
     * @param \StructType\IndividualType $individual
     * @param \StructType\OutboundBusinessNameType[] $businessName
     * @param \StructType\AgentType $agent
     */
    public function __construct(\StructType\AbrEntityType $abrEntity = null, \StructType\BaseNniEntityType $organisation = null, \StructType\IndividualType $individual = null, array $businessName = array(), \StructType\AgentType $agent = null)
    {
        $this
            ->setAbrEntity($abrEntity)
            ->setOrganisation($organisation)
            ->setIndividual($individual)
            ->setBusinessName($businessName)
            ->setAgent($agent);
    }
    /**
     * Get abrEntity value
     * @return \StructType\AbrEntityType|null
     */
    public function getAbrEntity()
    {
        return $this->abrEntity;
    }
    /**
     * Set abrEntity value
     * @param \StructType\AbrEntityType $abrEntity
     * @return \StructType\BusinessType
     */
    public function setAbrEntity(\StructType\AbrEntityType $abrEntity = null)
    {
        $this->abrEntity = $abrEntity;
        return $this;
    }
    /**
     * Get organisation value
     * @return \StructType\BaseNniEntityType|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param \StructType\BaseNniEntityType $organisation
     * @return \StructType\BusinessType
     */
    public function setOrganisation(\StructType\BaseNniEntityType $organisation = null)
    {
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get individual value
     * @return \StructType\IndividualType|null
     */
    public function getIndividual()
    {
        return $this->individual;
    }
    /**
     * Set individual value
     * @param \StructType\IndividualType $individual
     * @return \StructType\BusinessType
     */
    public function setIndividual(\StructType\IndividualType $individual = null)
    {
        $this->individual = $individual;
        return $this;
    }
    /**
     * Get businessName value
     * @return \StructType\OutboundBusinessNameType[]|null
     */
    public function getBusinessName()
    {
        return $this->businessName;
    }
    /**
     * Set businessName value
     * @throws \InvalidArgumentException
     * @param \StructType\OutboundBusinessNameType[] $businessName
     * @return \StructType\BusinessType
     */
    public function setBusinessName(array $businessName = array())
    {
        foreach ($businessName as $businessTypeBusinessNameItem) {
            // validation for constraint: itemType
            if (!$businessTypeBusinessNameItem instanceof \StructType\OutboundBusinessNameType) {
                throw new \InvalidArgumentException(sprintf('The businessName property can only contain items of \StructType\OutboundBusinessNameType, "%s" given', is_object($businessTypeBusinessNameItem) ? get_class($businessTypeBusinessNameItem) : gettype($businessTypeBusinessNameItem)), __LINE__);
            }
        }
        $this->businessName = $businessName;
        return $this;
    }
    /**
     * Add item to businessName value
     * @throws \InvalidArgumentException
     * @param \StructType\OutboundBusinessNameType $item
     * @return \StructType\BusinessType
     */
    public function addToBusinessName(\StructType\OutboundBusinessNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OutboundBusinessNameType) {
            throw new \InvalidArgumentException(sprintf('The businessName property can only contain items of \StructType\OutboundBusinessNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->businessName[] = $item;
        return $this;
    }
    /**
     * Get agent value
     * @return \StructType\AgentType|null
     */
    public function getAgent()
    {
        return $this->agent;
    }
    /**
     * Set agent value
     * @param \StructType\AgentType $agent
     * @return \StructType\BusinessType
     */
    public function setAgent(\StructType\AgentType $agent = null)
    {
        $this->agent = $agent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
