<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for businessNameExtractType StructType
 * @subpackage Structs
 */
class BusinessNameExtractType extends AbstractStructBase
{
    /**
     * The business
     * Meta informations extracted from the WSDL
     * - maxOccurs: 999
     * - minOccurs: 0
     * @var \StructType\Business[]
     */
    public $business;
    /**
     * The businessName
     * @var \StructType\OutboundBusinessNameType
     */
    public $businessName;
    /**
     * Constructor method for businessNameExtractType
     * @uses BusinessNameExtractType::setBusiness()
     * @uses BusinessNameExtractType::setBusinessName()
     * @param \StructType\Business[] $business
     * @param \StructType\OutboundBusinessNameType $businessName
     */
    public function __construct(array $business = array(), \StructType\OutboundBusinessNameType $businessName = null)
    {
        $this
            ->setBusiness($business)
            ->setBusinessName($businessName);
    }
    /**
     * Get business value
     * @return \StructType\Business[]|null
     */
    public function getBusiness()
    {
        return $this->business;
    }
    /**
     * Set business value
     * @throws \InvalidArgumentException
     * @param \StructType\Business[] $business
     * @return \StructType\BusinessNameExtractType
     */
    public function setBusiness(array $business = array())
    {
        foreach ($business as $businessNameExtractTypeBusinessItem) {
            // validation for constraint: itemType
            if (!$businessNameExtractTypeBusinessItem instanceof \StructType\Business) {
                throw new \InvalidArgumentException(sprintf('The business property can only contain items of \StructType\Business, "%s" given', is_object($businessNameExtractTypeBusinessItem) ? get_class($businessNameExtractTypeBusinessItem) : gettype($businessNameExtractTypeBusinessItem)), __LINE__);
            }
        }
        $this->business = $business;
        return $this;
    }
    /**
     * Add item to business value
     * @throws \InvalidArgumentException
     * @param \StructType\Business $item
     * @return \StructType\BusinessNameExtractType
     */
    public function addToBusiness(\StructType\Business $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business) {
            throw new \InvalidArgumentException(sprintf('The business property can only contain items of \StructType\Business, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->business[] = $item;
        return $this;
    }
    /**
     * Get businessName value
     * @return \StructType\OutboundBusinessNameType|null
     */
    public function getBusinessName()
    {
        return $this->businessName;
    }
    /**
     * Set businessName value
     * @param \StructType\OutboundBusinessNameType $businessName
     * @return \StructType\BusinessNameExtractType
     */
    public function setBusinessName(\StructType\OutboundBusinessNameType $businessName = null)
    {
        $this->businessName = $businessName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessNameExtractType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
