<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for businessEntityLodgeType StructType
 * @subpackage Structs
 */
class BusinessEntityLodgeType extends AbstractStructBase
{
    /**
     * The abrEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AbrEntityType
     */
    public $abrEntity;
    /**
     * The abnExemption
     * Meta informations extracted from the WSDL
     * - documentation: Xmas Island and Cocos Islands residents
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $abnExemption;
    /**
     * The individual
     * Meta informations extracted from the WSDL
     * - documentation: Sole TraderIndividual
     * @var \StructType\IndividualLodgeType
     */
    public $individual;
    /**
     * The organisation
     * Meta informations extracted from the WSDL
     * - documentation: CompanyPartnershipUnincorporateStructure
     * @var \StructType\OrganisationLodgeType
     */
    public $organisation;
    /**
     * The ownerType
     * @var string
     */
    public $ownerType;
    /**
     * The associate
     * Meta informations extracted from the WSDL
     * - documentation: Partners for PartnershipsReps for Trusts etcVentures for Joint Venturers
     * - maxOccurs: 500
     * - minOccurs: 0
     * @var \StructType\AssociateLodgeType[]
     */
    public $associate;
    /**
     * The dateReview
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateReview;
    /**
     * Constructor method for businessEntityLodgeType
     * @uses BusinessEntityLodgeType::setAbrEntity()
     * @uses BusinessEntityLodgeType::setAbnExemption()
     * @uses BusinessEntityLodgeType::setIndividual()
     * @uses BusinessEntityLodgeType::setOrganisation()
     * @uses BusinessEntityLodgeType::setOwnerType()
     * @uses BusinessEntityLodgeType::setAssociate()
     * @uses BusinessEntityLodgeType::setDateReview()
     * @param \StructType\AbrEntityType $abrEntity
     * @param bool $abnExemption
     * @param \StructType\IndividualLodgeType $individual
     * @param \StructType\OrganisationLodgeType $organisation
     * @param string $ownerType
     * @param \StructType\AssociateLodgeType[] $associate
     * @param string $dateReview
     */
    public function __construct(\StructType\AbrEntityType $abrEntity = null, $abnExemption = null, \StructType\IndividualLodgeType $individual = null, \StructType\OrganisationLodgeType $organisation = null, $ownerType = null, array $associate = array(), $dateReview = null)
    {
        $this
            ->setAbrEntity($abrEntity)
            ->setAbnExemption($abnExemption)
            ->setIndividual($individual)
            ->setOrganisation($organisation)
            ->setOwnerType($ownerType)
            ->setAssociate($associate)
            ->setDateReview($dateReview);
    }
    /**
     * Get abrEntity value
     * @return \StructType\AbrEntityType|null
     */
    public function getAbrEntity()
    {
        return $this->abrEntity;
    }
    /**
     * Set abrEntity value
     * @param \StructType\AbrEntityType $abrEntity
     * @return \StructType\BusinessEntityLodgeType
     */
    public function setAbrEntity(\StructType\AbrEntityType $abrEntity = null)
    {
        $this->abrEntity = $abrEntity;
        return $this;
    }
    /**
     * Get abnExemption value
     * @return bool|null
     */
    public function getAbnExemption()
    {
        return $this->abnExemption;
    }
    /**
     * Set abnExemption value
     * @param bool $abnExemption
     * @return \StructType\BusinessEntityLodgeType
     */
    public function setAbnExemption($abnExemption = null)
    {
        // validation for constraint: pattern
        if (is_scalar($abnExemption) && !preg_match('/true/', $abnExemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($abnExemption, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($abnExemption) && !is_bool($abnExemption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($abnExemption)), __LINE__);
        }
        $this->abnExemption = $abnExemption;
        return $this;
    }
    /**
     * Get individual value
     * @return \StructType\IndividualLodgeType|null
     */
    public function getIndividual()
    {
        return $this->individual;
    }
    /**
     * Set individual value
     * @param \StructType\IndividualLodgeType $individual
     * @return \StructType\BusinessEntityLodgeType
     */
    public function setIndividual(\StructType\IndividualLodgeType $individual = null)
    {
        $this->individual = $individual;
        return $this;
    }
    /**
     * Get organisation value
     * @return \StructType\OrganisationLodgeType|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param \StructType\OrganisationLodgeType $organisation
     * @return \StructType\BusinessEntityLodgeType
     */
    public function setOrganisation(\StructType\OrganisationLodgeType $organisation = null)
    {
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get ownerType value
     * @return string|null
     */
    public function getOwnerType()
    {
        return $this->ownerType;
    }
    /**
     * Set ownerType value
     * @uses \EnumType\OwnerType::valueIsValid()
     * @uses \EnumType\OwnerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ownerType
     * @return \StructType\BusinessEntityLodgeType
     */
    public function setOwnerType($ownerType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OwnerType::valueIsValid($ownerType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ownerType, implode(', ', \EnumType\OwnerType::getValidValues())), __LINE__);
        }
        $this->ownerType = $ownerType;
        return $this;
    }
    /**
     * Get associate value
     * @return \StructType\AssociateLodgeType[]|null
     */
    public function getAssociate()
    {
        return $this->associate;
    }
    /**
     * Set associate value
     * @throws \InvalidArgumentException
     * @param \StructType\AssociateLodgeType[] $associate
     * @return \StructType\BusinessEntityLodgeType
     */
    public function setAssociate(array $associate = array())
    {
        foreach ($associate as $businessEntityLodgeTypeAssociateItem) {
            // validation for constraint: itemType
            if (!$businessEntityLodgeTypeAssociateItem instanceof \StructType\AssociateLodgeType) {
                throw new \InvalidArgumentException(sprintf('The associate property can only contain items of \StructType\AssociateLodgeType, "%s" given', is_object($businessEntityLodgeTypeAssociateItem) ? get_class($businessEntityLodgeTypeAssociateItem) : gettype($businessEntityLodgeTypeAssociateItem)), __LINE__);
            }
        }
        $this->associate = $associate;
        return $this;
    }
    /**
     * Add item to associate value
     * @throws \InvalidArgumentException
     * @param \StructType\AssociateLodgeType $item
     * @return \StructType\BusinessEntityLodgeType
     */
    public function addToAssociate(\StructType\AssociateLodgeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssociateLodgeType) {
            throw new \InvalidArgumentException(sprintf('The associate property can only contain items of \StructType\AssociateLodgeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->associate[] = $item;
        return $this;
    }
    /**
     * Get dateReview value
     * @return string|null
     */
    public function getDateReview()
    {
        return $this->dateReview;
    }
    /**
     * Set dateReview value
     * @param string $dateReview
     * @return \StructType\BusinessEntityLodgeType
     */
    public function setDateReview($dateReview = null)
    {
        // validation for constraint: minInclusive
        if ($dateReview < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateReview), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateReview) && !is_string($dateReview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateReview)), __LINE__);
        }
        $this->dateReview = $dateReview;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessEntityLodgeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
