<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for businessDocumentHeaderType StructType
 * @subpackage Structs
 */
class BusinessDocumentHeaderType extends AbstractStructBase
{
    /**
     * The messageType
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $messageType;
    /**
     * The messageReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $messageReferenceNumber;
    /**
     * The asicReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $asicReferenceNumber;
    /**
     * The messageVersion
     * @var int
     */
    public $messageVersion;
    /**
     * The senderId
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $senderId;
    /**
     * The senderType
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $senderType;
    /**
     * The softwareInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SoftwareInformationType
     */
    public $softwareInformation;
    /**
     * The messageTimestamps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MessageTimestampsType
     */
    public $messageTimestamps;
    /**
     * The messageEvents
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MessageEventsType
     */
    public $messageEvents;
    /**
     * The result
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GenericResultType
     */
    public $result;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AttachmentsType
     */
    public $attachments;
    /**
     * The receipt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReceiptType
     */
    public $receipt;
    /**
     * The asicTransactionNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $asicTransactionNumber;
    /**
     * The transactionReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $transactionReferenceNumber;
    /**
     * The processMode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $processMode;
    /**
     * Constructor method for businessDocumentHeaderType
     * @uses BusinessDocumentHeaderType::setMessageType()
     * @uses BusinessDocumentHeaderType::setMessageReferenceNumber()
     * @uses BusinessDocumentHeaderType::setAsicReferenceNumber()
     * @uses BusinessDocumentHeaderType::setMessageVersion()
     * @uses BusinessDocumentHeaderType::setSenderId()
     * @uses BusinessDocumentHeaderType::setSenderType()
     * @uses BusinessDocumentHeaderType::setSoftwareInformation()
     * @uses BusinessDocumentHeaderType::setMessageTimestamps()
     * @uses BusinessDocumentHeaderType::setMessageEvents()
     * @uses BusinessDocumentHeaderType::setResult()
     * @uses BusinessDocumentHeaderType::setAttachments()
     * @uses BusinessDocumentHeaderType::setReceipt()
     * @uses BusinessDocumentHeaderType::setAsicTransactionNumber()
     * @uses BusinessDocumentHeaderType::setTransactionReferenceNumber()
     * @uses BusinessDocumentHeaderType::setProcessMode()
     * @param string $messageType
     * @param string $messageReferenceNumber
     * @param string $asicReferenceNumber
     * @param int $messageVersion
     * @param string $senderId
     * @param string $senderType
     * @param \StructType\SoftwareInformationType $softwareInformation
     * @param \StructType\MessageTimestampsType $messageTimestamps
     * @param \StructType\MessageEventsType $messageEvents
     * @param \StructType\GenericResultType $result
     * @param \StructType\AttachmentsType $attachments
     * @param \StructType\ReceiptType $receipt
     * @param string $asicTransactionNumber
     * @param string $transactionReferenceNumber
     * @param string $processMode
     */
    public function __construct($messageType = null, $messageReferenceNumber = null, $asicReferenceNumber = null, $messageVersion = null, $senderId = null, $senderType = null, \StructType\SoftwareInformationType $softwareInformation = null, \StructType\MessageTimestampsType $messageTimestamps = null, \StructType\MessageEventsType $messageEvents = null, \StructType\GenericResultType $result = null, \StructType\AttachmentsType $attachments = null, \StructType\ReceiptType $receipt = null, $asicTransactionNumber = null, $transactionReferenceNumber = null, $processMode = null)
    {
        $this
            ->setMessageType($messageType)
            ->setMessageReferenceNumber($messageReferenceNumber)
            ->setAsicReferenceNumber($asicReferenceNumber)
            ->setMessageVersion($messageVersion)
            ->setSenderId($senderId)
            ->setSenderType($senderType)
            ->setSoftwareInformation($softwareInformation)
            ->setMessageTimestamps($messageTimestamps)
            ->setMessageEvents($messageEvents)
            ->setResult($result)
            ->setAttachments($attachments)
            ->setReceipt($receipt)
            ->setAsicTransactionNumber($asicTransactionNumber)
            ->setTransactionReferenceNumber($transactionReferenceNumber)
            ->setProcessMode($processMode);
    }
    /**
     * Get messageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @param string $messageType
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageType) && strlen($messageType) > 100) || (is_array($messageType) && count($messageType) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($messageType) ? strlen($messageType) : count($messageType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($messageType) && strlen($messageType) < 1) || (is_array($messageType) && count($messageType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageType) && !is_string($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageType)), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Get messageReferenceNumber value
     * @return string|null
     */
    public function getMessageReferenceNumber()
    {
        return $this->messageReferenceNumber;
    }
    /**
     * Set messageReferenceNumber value
     * @param string $messageReferenceNumber
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setMessageReferenceNumber($messageReferenceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageReferenceNumber) && strlen($messageReferenceNumber) > 50) || (is_array($messageReferenceNumber) && count($messageReferenceNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($messageReferenceNumber) ? strlen($messageReferenceNumber) : count($messageReferenceNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($messageReferenceNumber) && strlen($messageReferenceNumber) < 1) || (is_array($messageReferenceNumber) && count($messageReferenceNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageReferenceNumber) && !is_string($messageReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageReferenceNumber)), __LINE__);
        }
        $this->messageReferenceNumber = $messageReferenceNumber;
        return $this;
    }
    /**
     * Get asicReferenceNumber value
     * @return string|null
     */
    public function getAsicReferenceNumber()
    {
        return $this->asicReferenceNumber;
    }
    /**
     * Set asicReferenceNumber value
     * @param string $asicReferenceNumber
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setAsicReferenceNumber($asicReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($asicReferenceNumber) && !is_string($asicReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asicReferenceNumber)), __LINE__);
        }
        $this->asicReferenceNumber = $asicReferenceNumber;
        return $this;
    }
    /**
     * Get messageVersion value
     * @return int|null
     */
    public function getMessageVersion()
    {
        return $this->messageVersion;
    }
    /**
     * Set messageVersion value
     * @param int $messageVersion
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setMessageVersion($messageVersion = null)
    {
        // validation for constraint: int
        if (!is_null($messageVersion) && !is_numeric($messageVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($messageVersion)), __LINE__);
        }
        $this->messageVersion = $messageVersion;
        return $this;
    }
    /**
     * Get senderId value
     * @return string|null
     */
    public function getSenderId()
    {
        return $this->senderId;
    }
    /**
     * Set senderId value
     * @param string $senderId
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setSenderId($senderId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($senderId) && strlen($senderId) > 50) || (is_array($senderId) && count($senderId) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($senderId) ? strlen($senderId) : count($senderId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($senderId) && strlen($senderId) < 1) || (is_array($senderId) && count($senderId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($senderId) && !is_string($senderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderId)), __LINE__);
        }
        $this->senderId = $senderId;
        return $this;
    }
    /**
     * Get senderType value
     * @return string|null
     */
    public function getSenderType()
    {
        return $this->senderType;
    }
    /**
     * Set senderType value
     * @param string $senderType
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setSenderType($senderType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($senderType) && strlen($senderType) > 50) || (is_array($senderType) && count($senderType) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($senderType) ? strlen($senderType) : count($senderType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($senderType) && strlen($senderType) < 1) || (is_array($senderType) && count($senderType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($senderType) && !is_string($senderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderType)), __LINE__);
        }
        $this->senderType = $senderType;
        return $this;
    }
    /**
     * Get softwareInformation value
     * @return \StructType\SoftwareInformationType|null
     */
    public function getSoftwareInformation()
    {
        return $this->softwareInformation;
    }
    /**
     * Set softwareInformation value
     * @param \StructType\SoftwareInformationType $softwareInformation
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setSoftwareInformation(\StructType\SoftwareInformationType $softwareInformation = null)
    {
        $this->softwareInformation = $softwareInformation;
        return $this;
    }
    /**
     * Get messageTimestamps value
     * @return \StructType\MessageTimestampsType|null
     */
    public function getMessageTimestamps()
    {
        return $this->messageTimestamps;
    }
    /**
     * Set messageTimestamps value
     * @param \StructType\MessageTimestampsType $messageTimestamps
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setMessageTimestamps(\StructType\MessageTimestampsType $messageTimestamps = null)
    {
        $this->messageTimestamps = $messageTimestamps;
        return $this;
    }
    /**
     * Get messageEvents value
     * @return \StructType\MessageEventsType|null
     */
    public function getMessageEvents()
    {
        return $this->messageEvents;
    }
    /**
     * Set messageEvents value
     * @param \StructType\MessageEventsType $messageEvents
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setMessageEvents(\StructType\MessageEventsType $messageEvents = null)
    {
        $this->messageEvents = $messageEvents;
        return $this;
    }
    /**
     * Get result value
     * @return \StructType\GenericResultType|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param \StructType\GenericResultType $result
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setResult(\StructType\GenericResultType $result = null)
    {
        $this->result = $result;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\AttachmentsType|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @param \StructType\AttachmentsType $attachments
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setAttachments(\StructType\AttachmentsType $attachments = null)
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Get receipt value
     * @return \StructType\ReceiptType|null
     */
    public function getReceipt()
    {
        return $this->receipt;
    }
    /**
     * Set receipt value
     * @param \StructType\ReceiptType $receipt
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setReceipt(\StructType\ReceiptType $receipt = null)
    {
        $this->receipt = $receipt;
        return $this;
    }
    /**
     * Get asicTransactionNumber value
     * @return string|null
     */
    public function getAsicTransactionNumber()
    {
        return $this->asicTransactionNumber;
    }
    /**
     * Set asicTransactionNumber value
     * @param string $asicTransactionNumber
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setAsicTransactionNumber($asicTransactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($asicTransactionNumber) && !is_string($asicTransactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asicTransactionNumber)), __LINE__);
        }
        $this->asicTransactionNumber = $asicTransactionNumber;
        return $this;
    }
    /**
     * Get transactionReferenceNumber value
     * @return string|null
     */
    public function getTransactionReferenceNumber()
    {
        return $this->transactionReferenceNumber;
    }
    /**
     * Set transactionReferenceNumber value
     * @param string $transactionReferenceNumber
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setTransactionReferenceNumber($transactionReferenceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($transactionReferenceNumber) && strlen($transactionReferenceNumber) > 64) || (is_array($transactionReferenceNumber) && count($transactionReferenceNumber) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($transactionReferenceNumber) ? strlen($transactionReferenceNumber) : count($transactionReferenceNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($transactionReferenceNumber) && strlen($transactionReferenceNumber) < 1) || (is_array($transactionReferenceNumber) && count($transactionReferenceNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transactionReferenceNumber) && !is_string($transactionReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionReferenceNumber)), __LINE__);
        }
        $this->transactionReferenceNumber = $transactionReferenceNumber;
        return $this;
    }
    /**
     * Get processMode value
     * @return string|null
     */
    public function getProcessMode()
    {
        return $this->processMode;
    }
    /**
     * Set processMode value
     * @uses \EnumType\ProcessMode::valueIsValid()
     * @uses \EnumType\ProcessMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $processMode
     * @return \StructType\BusinessDocumentHeaderType
     */
    public function setProcessMode($processMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProcessMode::valueIsValid($processMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $processMode, implode(', ', \EnumType\ProcessMode::getValidValues())), __LINE__);
        }
        $this->processMode = $processMode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessDocumentHeaderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
