<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for browserIdentifierType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Identity for a browser message.
 * @subpackage Structs
 */
class BrowserIdentifierType extends AbstractStructBase
{
    /**
     * The transactionNo
     * Meta informations extracted from the WSDL
     * - documentation: eLodgement allocated
     * - maxLength: 128
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $transactionNo;
    /**
     * Constructor method for browserIdentifierType
     * @uses BrowserIdentifierType::setTransactionNo()
     * @param string $transactionNo
     */
    public function __construct($transactionNo = null)
    {
        $this
            ->setTransactionNo($transactionNo);
    }
    /**
     * Get transactionNo value
     * @return string|null
     */
    public function getTransactionNo()
    {
        return $this->transactionNo;
    }
    /**
     * Set transactionNo value
     * @param string $transactionNo
     * @return \StructType\BrowserIdentifierType
     */
    public function setTransactionNo($transactionNo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($transactionNo) && strlen($transactionNo) > 128) || (is_array($transactionNo) && count($transactionNo) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($transactionNo) ? strlen($transactionNo) : count($transactionNo)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($transactionNo) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $transactionNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($transactionNo, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transactionNo) && !is_string($transactionNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionNo)), __LINE__);
        }
        $this->transactionNo = $transactionNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BrowserIdentifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
