<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bpay StructType
 * @subpackage Structs
 */
class Bpay extends AbstractStructBase
{
    /**
     * The billerCode
     * Meta informations extracted from the WSDL
     * - maxLength: 5
     * @var string
     */
    public $billerCode;
    /**
     * The ref
     * Meta informations extracted from the WSDL
     * - maxLength: 18
     * @var string
     */
    public $ref;
    /**
     * Constructor method for bpay
     * @uses Bpay::setBillerCode()
     * @uses Bpay::setRef()
     * @param string $billerCode
     * @param string $ref
     */
    public function __construct($billerCode = null, $ref = null)
    {
        $this
            ->setBillerCode($billerCode)
            ->setRef($ref);
    }
    /**
     * Get billerCode value
     * @return string|null
     */
    public function getBillerCode()
    {
        return $this->billerCode;
    }
    /**
     * Set billerCode value
     * @param string $billerCode
     * @return \StructType\Bpay
     */
    public function setBillerCode($billerCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($billerCode) && strlen($billerCode) > 5) || (is_array($billerCode) && count($billerCode) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($billerCode) ? strlen($billerCode) : count($billerCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($billerCode) && !is_string($billerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billerCode)), __LINE__);
        }
        $this->billerCode = $billerCode;
        return $this;
    }
    /**
     * Get ref value
     * @return string|null
     */
    public function getRef()
    {
        return $this->ref;
    }
    /**
     * Set ref value
     * @param string $ref
     * @return \StructType\Bpay
     */
    public function setRef($ref = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ref) && strlen($ref) > 18) || (is_array($ref) && count($ref) > 18)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 18 element(s) or a scalar of 18 character(s) at most, "%d" length given', is_scalar($ref) ? strlen($ref) : count($ref)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ref)), __LINE__);
        }
        $this->ref = $ref;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Bpay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
