<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bnUpdateFormType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Form BZ4 definition
 * @subpackage Structs
 */
class BnUpdateFormType extends AbstractStructBase
{
    /**
     * The number
     * @var \StructType\BnIdentifier
     */
    public $number;
    /**
     * The name
     * @var \StructType\DistinguishedNameType
     */
    public $name;
    /**
     * The term
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $term;
    /**
     * The dateRegistered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateRegistered;
    /**
     * The dateRenewal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateRenewal;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var string[]
     */
    public $address;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - documentation: email address
     * - maxLength: 200
     * @var string
     */
    public $emailAddress;
    /**
     * The smsNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 15
     * @var string
     */
    public $smsNumber;
    /**
     * The representative
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\RepresentativeType[]
     */
    public $representative;
    /**
     * The businessEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BusinessEntityType
     */
    public $businessEntity;
    /**
     * The signatory
     * @var \StructType\SignatoryType
     */
    public $signatory;
    /**
     * Constructor method for bnUpdateFormType
     * @uses BnUpdateFormType::setNumber()
     * @uses BnUpdateFormType::setName()
     * @uses BnUpdateFormType::setTerm()
     * @uses BnUpdateFormType::setDateRegistered()
     * @uses BnUpdateFormType::setDateRenewal()
     * @uses BnUpdateFormType::setAddress()
     * @uses BnUpdateFormType::setEmailAddress()
     * @uses BnUpdateFormType::setSmsNumber()
     * @uses BnUpdateFormType::setRepresentative()
     * @uses BnUpdateFormType::setBusinessEntity()
     * @uses BnUpdateFormType::setSignatory()
     * @param \StructType\BnIdentifier $number
     * @param \StructType\DistinguishedNameType $name
     * @param string $term
     * @param string $dateRegistered
     * @param string $dateRenewal
     * @param string[] $address
     * @param string $emailAddress
     * @param string $smsNumber
     * @param \StructType\RepresentativeType[] $representative
     * @param \StructType\BusinessEntityType $businessEntity
     * @param \StructType\SignatoryType $signatory
     */
    public function __construct(\StructType\BnIdentifier $number = null, \StructType\DistinguishedNameType $name = null, $term = null, $dateRegistered = null, $dateRenewal = null, array $address = array(), $emailAddress = null, $smsNumber = null, array $representative = array(), \StructType\BusinessEntityType $businessEntity = null, \StructType\SignatoryType $signatory = null)
    {
        $this
            ->setNumber($number)
            ->setName($name)
            ->setTerm($term)
            ->setDateRegistered($dateRegistered)
            ->setDateRenewal($dateRenewal)
            ->setAddress($address)
            ->setEmailAddress($emailAddress)
            ->setSmsNumber($smsNumber)
            ->setRepresentative($representative)
            ->setBusinessEntity($businessEntity)
            ->setSignatory($signatory);
    }
    /**
     * Get number value
     * @return \StructType\BnIdentifier|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param \StructType\BnIdentifier $number
     * @return \StructType\BnUpdateFormType
     */
    public function setNumber(\StructType\BnIdentifier $number = null)
    {
        $this->number = $number;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\DistinguishedNameType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\DistinguishedNameType $name
     * @return \StructType\BnUpdateFormType
     */
    public function setName(\StructType\DistinguishedNameType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get term value
     * @return string|null
     */
    public function getTerm()
    {
        return $this->term;
    }
    /**
     * Set term value
     * @uses \EnumType\TermType::valueIsValid()
     * @uses \EnumType\TermType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $term
     * @return \StructType\BnUpdateFormType
     */
    public function setTerm($term = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TermType::valueIsValid($term)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $term, implode(', ', \EnumType\TermType::getValidValues())), __LINE__);
        }
        $this->term = $term;
        return $this;
    }
    /**
     * Get dateRegistered value
     * @return string|null
     */
    public function getDateRegistered()
    {
        return $this->dateRegistered;
    }
    /**
     * Set dateRegistered value
     * @param string $dateRegistered
     * @return \StructType\BnUpdateFormType
     */
    public function setDateRegistered($dateRegistered = null)
    {
        // validation for constraint: minInclusive
        if ($dateRegistered < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateRegistered), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateRegistered) && !is_string($dateRegistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRegistered)), __LINE__);
        }
        $this->dateRegistered = $dateRegistered;
        return $this;
    }
    /**
     * Get dateRenewal value
     * @return string|null
     */
    public function getDateRenewal()
    {
        return $this->dateRenewal;
    }
    /**
     * Set dateRenewal value
     * @param string $dateRenewal
     * @return \StructType\BnUpdateFormType
     */
    public function setDateRenewal($dateRenewal = null)
    {
        // validation for constraint: minInclusive
        if ($dateRenewal < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateRenewal), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateRenewal) && !is_string($dateRenewal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRenewal)), __LINE__);
        }
        $this->dateRenewal = $dateRenewal;
        return $this;
    }
    /**
     * Get address value
     * @return string[]|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @uses \EnumType\AddressType::valueIsValid()
     * @uses \EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $address
     * @return \StructType\BnUpdateFormType
     */
    public function setAddress(array $address = array())
    {
        $invalidValues = array();
        foreach ($address as $bnUpdateFormTypeAddressItem) {
            if (!\EnumType\AddressType::valueIsValid($bnUpdateFormTypeAddressItem)) {
                $invalidValues[] = var_export($bnUpdateFormTypeAddressItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @uses \EnumType\AddressType::valueIsValid()
     * @uses \EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BnUpdateFormType
     */
    public function addToAddress($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddressType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->address[] = $item;
        return $this;
    }
    /**
     * Get emailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAddress()
    {
        return isset($this->emailAddress) ? $this->emailAddress : null;
    }
    /**
     * Set emailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAddress
     * @return \StructType\BnUpdateFormType
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($emailAddress) && strlen($emailAddress) > 200) || (is_array($emailAddress) && count($emailAddress) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($emailAddress) ? strlen($emailAddress) : count($emailAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        if (is_null($emailAddress) || (is_array($emailAddress) && empty($emailAddress))) {
            unset($this->emailAddress);
        } else {
            $this->emailAddress = $emailAddress;
        }
        return $this;
    }
    /**
     * Get smsNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSmsNumber()
    {
        return isset($this->smsNumber) ? $this->smsNumber : null;
    }
    /**
     * Set smsNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $smsNumber
     * @return \StructType\BnUpdateFormType
     */
    public function setSmsNumber($smsNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($smsNumber) && strlen($smsNumber) > 15) || (is_array($smsNumber) && count($smsNumber) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($smsNumber) ? strlen($smsNumber) : count($smsNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($smsNumber) && !is_string($smsNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($smsNumber)), __LINE__);
        }
        if (is_null($smsNumber) || (is_array($smsNumber) && empty($smsNumber))) {
            unset($this->smsNumber);
        } else {
            $this->smsNumber = $smsNumber;
        }
        return $this;
    }
    /**
     * Get representative value
     * @return \StructType\RepresentativeType[]|null
     */
    public function getRepresentative()
    {
        return $this->representative;
    }
    /**
     * Set representative value
     * @throws \InvalidArgumentException
     * @param \StructType\RepresentativeType[] $representative
     * @return \StructType\BnUpdateFormType
     */
    public function setRepresentative(array $representative = array())
    {
        foreach ($representative as $bnUpdateFormTypeRepresentativeItem) {
            // validation for constraint: itemType
            if (!$bnUpdateFormTypeRepresentativeItem instanceof \StructType\RepresentativeType) {
                throw new \InvalidArgumentException(sprintf('The representative property can only contain items of \StructType\RepresentativeType, "%s" given', is_object($bnUpdateFormTypeRepresentativeItem) ? get_class($bnUpdateFormTypeRepresentativeItem) : gettype($bnUpdateFormTypeRepresentativeItem)), __LINE__);
            }
        }
        $this->representative = $representative;
        return $this;
    }
    /**
     * Add item to representative value
     * @throws \InvalidArgumentException
     * @param \StructType\RepresentativeType $item
     * @return \StructType\BnUpdateFormType
     */
    public function addToRepresentative(\StructType\RepresentativeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RepresentativeType) {
            throw new \InvalidArgumentException(sprintf('The representative property can only contain items of \StructType\RepresentativeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->representative[] = $item;
        return $this;
    }
    /**
     * Get businessEntity value
     * @return \StructType\BusinessEntityType|null
     */
    public function getBusinessEntity()
    {
        return $this->businessEntity;
    }
    /**
     * Set businessEntity value
     * @param \StructType\BusinessEntityType $businessEntity
     * @return \StructType\BnUpdateFormType
     */
    public function setBusinessEntity(\StructType\BusinessEntityType $businessEntity = null)
    {
        $this->businessEntity = $businessEntity;
        return $this;
    }
    /**
     * Get signatory value
     * @return \StructType\SignatoryType|null
     */
    public function getSignatory()
    {
        return $this->signatory;
    }
    /**
     * Set signatory value
     * @param \StructType\SignatoryType $signatory
     * @return \StructType\BnUpdateFormType
     */
    public function setSignatory(\StructType\SignatoryType $signatory = null)
    {
        $this->signatory = $signatory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BnUpdateFormType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
