<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bnSearchRequestType StructType
 * @subpackage Structs
 */
class BnSearchRequestType extends AbstractStructBase
{
    /**
     * The search
     * @var \StructType\Search
     */
    public $search;
    /**
     * The filter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Filter
     */
    public $filter;
    /**
     * The maxResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maxResult;
    /**
     * Constructor method for bnSearchRequestType
     * @uses BnSearchRequestType::setSearch()
     * @uses BnSearchRequestType::setFilter()
     * @uses BnSearchRequestType::setMaxResult()
     * @param \StructType\Search $search
     * @param \StructType\Filter $filter
     * @param int $maxResult
     */
    public function __construct(\StructType\Search $search = null, \StructType\Filter $filter = null, $maxResult = null)
    {
        $this
            ->setSearch($search)
            ->setFilter($filter)
            ->setMaxResult($maxResult);
    }
    /**
     * Get search value
     * @return \StructType\Search|null
     */
    public function getSearch()
    {
        return $this->search;
    }
    /**
     * Set search value
     * @param \StructType\Search $search
     * @return \StructType\BnSearchRequestType
     */
    public function setSearch(\StructType\Search $search = null)
    {
        $this->search = $search;
        return $this;
    }
    /**
     * Get filter value
     * @return \StructType\Filter|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @param \StructType\Filter $filter
     * @return \StructType\BnSearchRequestType
     */
    public function setFilter(\StructType\Filter $filter = null)
    {
        $this->filter = $filter;
        return $this;
    }
    /**
     * Get maxResult value
     * @return int|null
     */
    public function getMaxResult()
    {
        return $this->maxResult;
    }
    /**
     * Set maxResult value
     * @param int $maxResult
     * @return \StructType\BnSearchRequestType
     */
    public function setMaxResult($maxResult = null)
    {
        // validation for constraint: int
        if (!is_null($maxResult) && !is_numeric($maxResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxResult)), __LINE__);
        }
        $this->maxResult = $maxResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BnSearchRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
