<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bnLinkFormType StructType
 * @subpackage Structs
 */
class BnLinkFormType extends AbstractStructBase
{
    /**
     * The abn
     * Meta informations extracted from the WSDL
     * - documentation: abn of business name owner | ABN as 99999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: ([0-9]{11})
     * @var string
     */
    public $abn;
    /**
     * The nniNumber
     * Meta informations extracted from the WSDL
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $nniNumber;
    /**
     * The agent
     * @var \StructType\AgentType
     */
    public $agent;
    /**
     * The action
     * @var string
     */
    public $action;
    /**
     * The signatory
     * Meta informations extracted from the WSDL
     * - documentation: ~ExternalMandatory~
     * - minOccurs: 0
     * @var \StructType\SignatoryType
     */
    public $signatory;
    /**
     * The fileNotes
     * Meta informations extracted from the WSDL
     * - documentation: ~Internal~
     * - minOccurs: 0
     * @var \StructType\FileNotesType
     */
    public $fileNotes;
    /**
     * Constructor method for bnLinkFormType
     * @uses BnLinkFormType::setAbn()
     * @uses BnLinkFormType::setNniNumber()
     * @uses BnLinkFormType::setAgent()
     * @uses BnLinkFormType::setAction()
     * @uses BnLinkFormType::setSignatory()
     * @uses BnLinkFormType::setFileNotes()
     * @param string $abn
     * @param int $nniNumber
     * @param \StructType\AgentType $agent
     * @param string $action
     * @param \StructType\SignatoryType $signatory
     * @param \StructType\FileNotesType $fileNotes
     */
    public function __construct($abn = null, $nniNumber = null, \StructType\AgentType $agent = null, $action = null, \StructType\SignatoryType $signatory = null, \StructType\FileNotesType $fileNotes = null)
    {
        $this
            ->setAbn($abn)
            ->setNniNumber($nniNumber)
            ->setAgent($agent)
            ->setAction($action)
            ->setSignatory($signatory)
            ->setFileNotes($fileNotes);
    }
    /**
     * Get abn value
     * @return string|null
     */
    public function getAbn()
    {
        return $this->abn;
    }
    /**
     * Set abn value
     * @param string $abn
     * @return \StructType\BnLinkFormType
     */
    public function setAbn($abn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abn) && strlen($abn) > 11) || (is_array($abn) && count($abn) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($abn) ? strlen($abn) : count($abn)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($abn) && strlen($abn) < 11) || (is_array($abn) && count($abn) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($abn) && !preg_match('/([0-9]{11})/', $abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{11})", "%s" given', var_export($abn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abn) && !is_string($abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abn)), __LINE__);
        }
        $this->abn = $abn;
        return $this;
    }
    /**
     * Get nniNumber value
     * @return int|null
     */
    public function getNniNumber()
    {
        return $this->nniNumber;
    }
    /**
     * Set nniNumber value
     * @param int $nniNumber
     * @return \StructType\BnLinkFormType
     */
    public function setNniNumber($nniNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($nniNumber > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $nniNumber), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($nniNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $nniNumber), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($nniNumber) && !is_numeric($nniNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nniNumber)), __LINE__);
        }
        $this->nniNumber = $nniNumber;
        return $this;
    }
    /**
     * Get agent value
     * @return \StructType\AgentType|null
     */
    public function getAgent()
    {
        return $this->agent;
    }
    /**
     * Set agent value
     * @param \StructType\AgentType $agent
     * @return \StructType\BnLinkFormType
     */
    public function setAgent(\StructType\AgentType $agent = null)
    {
        $this->agent = $agent;
        return $this;
    }
    /**
     * Get action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @uses \EnumType\Action::valueIsValid()
     * @uses \EnumType\Action::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\BnLinkFormType
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Action::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\Action::getValidValues())), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get signatory value
     * @return \StructType\SignatoryType|null
     */
    public function getSignatory()
    {
        return $this->signatory;
    }
    /**
     * Set signatory value
     * @param \StructType\SignatoryType $signatory
     * @return \StructType\BnLinkFormType
     */
    public function setSignatory(\StructType\SignatoryType $signatory = null)
    {
        $this->signatory = $signatory;
        return $this;
    }
    /**
     * Get fileNotes value
     * @return \StructType\FileNotesType|null
     */
    public function getFileNotes()
    {
        return $this->fileNotes;
    }
    /**
     * Set fileNotes value
     * @param \StructType\FileNotesType $fileNotes
     * @return \StructType\BnLinkFormType
     */
    public function setFileNotes(\StructType\FileNotesType $fileNotes = null)
    {
        $this->fileNotes = $fileNotes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BnLinkFormType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
