<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bnCancelFormType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Form BZ5 definitionBZ5A Owner cancellationBZ5C Staff cancellationBZ5D ABR cancellation
 * @subpackage Structs
 */
class BnCancelFormType extends AbstractStructBase
{
    /**
     * The businessName
     * @var \StructType\BnIdentifier
     */
    public $businessName;
    /**
     * The transfer
     * Meta informations extracted from the WSDL
     * - documentation: Transfers every business name identified by abn
     * - minOccurs: 0
     * @var bool
     */
    public $transfer;
    /**
     * The signatory
     * Meta informations extracted from the WSDL
     * - documentation: ~ExternalMandatory~
     * - minOccurs: 0
     * @var \StructType\SignatoryType
     */
    public $signatory;
    /**
     * The fileNotes
     * Meta informations extracted from the WSDL
     * - documentation: ~Internal~
     * - minOccurs: 0
     * @var \StructType\FileNotesType
     */
    public $fileNotes;
    /**
     * The returnExtract
     * Meta informations extracted from the WSDL
     * - documentation: ~Internal~
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $returnExtract;
    /**
     * Constructor method for bnCancelFormType
     * @uses BnCancelFormType::setBusinessName()
     * @uses BnCancelFormType::setTransfer()
     * @uses BnCancelFormType::setSignatory()
     * @uses BnCancelFormType::setFileNotes()
     * @uses BnCancelFormType::setReturnExtract()
     * @param \StructType\BnIdentifier $businessName
     * @param bool $transfer
     * @param \StructType\SignatoryType $signatory
     * @param \StructType\FileNotesType $fileNotes
     * @param bool $returnExtract
     */
    public function __construct(\StructType\BnIdentifier $businessName = null, $transfer = null, \StructType\SignatoryType $signatory = null, \StructType\FileNotesType $fileNotes = null, $returnExtract = null)
    {
        $this
            ->setBusinessName($businessName)
            ->setTransfer($transfer)
            ->setSignatory($signatory)
            ->setFileNotes($fileNotes)
            ->setReturnExtract($returnExtract);
    }
    /**
     * Get businessName value
     * @return \StructType\BnIdentifier|null
     */
    public function getBusinessName()
    {
        return $this->businessName;
    }
    /**
     * Set businessName value
     * @param \StructType\BnIdentifier $businessName
     * @return \StructType\BnCancelFormType
     */
    public function setBusinessName(\StructType\BnIdentifier $businessName = null)
    {
        $this->businessName = $businessName;
        return $this;
    }
    /**
     * Get transfer value
     * @return bool|null
     */
    public function getTransfer()
    {
        return $this->transfer;
    }
    /**
     * Set transfer value
     * @param bool $transfer
     * @return \StructType\BnCancelFormType
     */
    public function setTransfer($transfer = null)
    {
        // validation for constraint: boolean
        if (!is_null($transfer) && !is_bool($transfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($transfer)), __LINE__);
        }
        $this->transfer = $transfer;
        return $this;
    }
    /**
     * Get signatory value
     * @return \StructType\SignatoryType|null
     */
    public function getSignatory()
    {
        return $this->signatory;
    }
    /**
     * Set signatory value
     * @param \StructType\SignatoryType $signatory
     * @return \StructType\BnCancelFormType
     */
    public function setSignatory(\StructType\SignatoryType $signatory = null)
    {
        $this->signatory = $signatory;
        return $this;
    }
    /**
     * Get fileNotes value
     * @return \StructType\FileNotesType|null
     */
    public function getFileNotes()
    {
        return $this->fileNotes;
    }
    /**
     * Set fileNotes value
     * @param \StructType\FileNotesType $fileNotes
     * @return \StructType\BnCancelFormType
     */
    public function setFileNotes(\StructType\FileNotesType $fileNotes = null)
    {
        $this->fileNotes = $fileNotes;
        return $this;
    }
    /**
     * Get returnExtract value
     * @return bool|null
     */
    public function getReturnExtract()
    {
        return $this->returnExtract;
    }
    /**
     * Set returnExtract value
     * @param bool $returnExtract
     * @return \StructType\BnCancelFormType
     */
    public function setReturnExtract($returnExtract = null)
    {
        // validation for constraint: pattern
        if (is_scalar($returnExtract) && !preg_match('/true/', $returnExtract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($returnExtract, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($returnExtract) && !is_bool($returnExtract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnExtract)), __LINE__);
        }
        $this->returnExtract = $returnExtract;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BnCancelFormType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
