<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for birthDetailsType StructType
 * @subpackage Structs
 */
class BirthDetailsType extends AbstractStructBase
{
    /**
     * The date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $date;
    /**
     * The cityTown
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 30
     * @var string
     */
    public $cityTown;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The iso3166CountryCode
     * Meta informations extracted from the WSDL
     * - maxLength: 2
     * - minLength: 2
     * - pattern: [A-Z]*
     * @var string
     */
    public $iso3166CountryCode;
    /**
     * The countryOfBirth
     * Meta informations extracted from the WSDL
     * - documentation: LOV
     * - maxLength: 75
     * @var string
     */
    public $countryOfBirth;
    /**
     * Constructor method for birthDetailsType
     * @uses BirthDetailsType::setDate()
     * @uses BirthDetailsType::setCityTown()
     * @uses BirthDetailsType::setState()
     * @uses BirthDetailsType::setIso3166CountryCode()
     * @uses BirthDetailsType::setCountryOfBirth()
     * @param string $date
     * @param string $cityTown
     * @param string $state
     * @param string $iso3166CountryCode
     * @param string $countryOfBirth
     */
    public function __construct($date = null, $cityTown = null, $state = null, $iso3166CountryCode = null, $countryOfBirth = null)
    {
        $this
            ->setDate($date)
            ->setCityTown($cityTown)
            ->setState($state)
            ->setIso3166CountryCode($iso3166CountryCode)
            ->setCountryOfBirth($countryOfBirth);
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\BirthDetailsType
     */
    public function setDate($date = null)
    {
        // validation for constraint: minInclusive
        if ($date < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $date), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get cityTown value
     * @return string|null
     */
    public function getCityTown()
    {
        return $this->cityTown;
    }
    /**
     * Set cityTown value
     * @param string $cityTown
     * @return \StructType\BirthDetailsType
     */
    public function setCityTown($cityTown = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cityTown) && strlen($cityTown) > 30) || (is_array($cityTown) && count($cityTown) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($cityTown) ? strlen($cityTown) : count($cityTown)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cityTown) && !is_string($cityTown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityTown)), __LINE__);
        }
        $this->cityTown = $cityTown;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \EnumType\StateTerritoryCodeType::valueIsValid()
     * @uses \EnumType\StateTerritoryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\BirthDetailsType
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StateTerritoryCodeType::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \EnumType\StateTerritoryCodeType::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get iso3166CountryCode value
     * @return string|null
     */
    public function getIso3166CountryCode()
    {
        return $this->iso3166CountryCode;
    }
    /**
     * Set iso3166CountryCode value
     * @param string $iso3166CountryCode
     * @return \StructType\BirthDetailsType
     */
    public function setIso3166CountryCode($iso3166CountryCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iso3166CountryCode) && strlen($iso3166CountryCode) > 2) || (is_array($iso3166CountryCode) && count($iso3166CountryCode) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($iso3166CountryCode) ? strlen($iso3166CountryCode) : count($iso3166CountryCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iso3166CountryCode) && strlen($iso3166CountryCode) < 2) || (is_array($iso3166CountryCode) && count($iso3166CountryCode) < 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($iso3166CountryCode) && !preg_match('/[A-Z]*/', $iso3166CountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z]*", "%s" given', var_export($iso3166CountryCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iso3166CountryCode) && !is_string($iso3166CountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso3166CountryCode)), __LINE__);
        }
        $this->iso3166CountryCode = $iso3166CountryCode;
        return $this;
    }
    /**
     * Get countryOfBirth value
     * @return string|null
     */
    public function getCountryOfBirth()
    {
        return $this->countryOfBirth;
    }
    /**
     * Set countryOfBirth value
     * @param string $countryOfBirth
     * @return \StructType\BirthDetailsType
     */
    public function setCountryOfBirth($countryOfBirth = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($countryOfBirth) && strlen($countryOfBirth) > 75) || (is_array($countryOfBirth) && count($countryOfBirth) > 75)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 75 element(s) or a scalar of 75 character(s) at most, "%d" length given', is_scalar($countryOfBirth) ? strlen($countryOfBirth) : count($countryOfBirth)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryOfBirth) && !is_string($countryOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryOfBirth)), __LINE__);
        }
        $this->countryOfBirth = $countryOfBirth;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BirthDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
