<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for billingType StructType
 * @subpackage Structs
 */
class BillingType extends AbstractStructBase
{
    /**
     * The charge
     * @var \StructType\Charge
     */
    public $charge;
    /**
     * The fees
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InvoiceType
     */
    public $fees;
    /**
     * Constructor method for billingType
     * @uses BillingType::setCharge()
     * @uses BillingType::setFees()
     * @param \StructType\Charge $charge
     * @param \StructType\InvoiceType $fees
     */
    public function __construct(\StructType\Charge $charge = null, \StructType\InvoiceType $fees = null)
    {
        $this
            ->setCharge($charge)
            ->setFees($fees);
    }
    /**
     * Get charge value
     * @return \StructType\Charge|null
     */
    public function getCharge()
    {
        return $this->charge;
    }
    /**
     * Set charge value
     * @param \StructType\Charge $charge
     * @return \StructType\BillingType
     */
    public function setCharge(\StructType\Charge $charge = null)
    {
        $this->charge = $charge;
        return $this;
    }
    /**
     * Get fees value
     * @return \StructType\InvoiceType|null
     */
    public function getFees()
    {
        return $this->fees;
    }
    /**
     * Set fees value
     * @param \StructType\InvoiceType $fees
     * @return \StructType\BillingType
     */
    public function setFees(\StructType\InvoiceType $fees = null)
    {
        $this->fees = $fees;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BillingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
