<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for attachmentType StructType
 * @subpackage Structs
 */
class AttachmentType extends AbstractStructBase
{
    /**
     * The documentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocumentType
     */
    public $documentType;
    /**
     * The binaryObject
     * Meta informations extracted from the WSDL
     * - expectedContentTypes: application/pdf
     * - minOccurs: 0
     * @var \StructType\Base64Binary
     */
    public $binaryObject;
    /**
     * The documentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Ascot document number
     * - maxLength: 9
     * - minLength: 1
     * - pattern: [A-Z0-9\.]*
     * @var string
     */
    public $documentNumber;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Holder name or business name, according with roleCategory value in filter element | composite person name or organisation name
     * - maxLength: 200
     * - minLength: 1
     * - pattern: [A-Z0-9\.\\!\(\):;\?',\-&"=$%#\|/_\{\}\*@ ]*
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $description;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for attachmentType
     * @uses AttachmentType::setDocumentType()
     * @uses AttachmentType::setBinaryObject()
     * @uses AttachmentType::setDocumentNumber()
     * @uses AttachmentType::setName()
     * @uses AttachmentType::setDescription()
     * @uses AttachmentType::setURL()
     * @param \StructType\DocumentType $documentType
     * @param \StructType\Base64Binary $binaryObject
     * @param string $documentNumber
     * @param string $name
     * @param string $description
     * @param string $uRL
     */
    public function __construct(\StructType\DocumentType $documentType = null, \StructType\Base64Binary $binaryObject = null, $documentNumber = null, $name = null, $description = null, $uRL = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setBinaryObject($binaryObject)
            ->setDocumentNumber($documentNumber)
            ->setName($name)
            ->setDescription($description)
            ->setURL($uRL);
    }
    /**
     * Get documentType value
     * @return \StructType\DocumentType|null
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @param \StructType\DocumentType $documentType
     * @return \StructType\AttachmentType
     */
    public function setDocumentType(\StructType\DocumentType $documentType = null)
    {
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get binaryObject value
     * @return \StructType\Base64Binary|null
     */
    public function getBinaryObject()
    {
        return $this->binaryObject;
    }
    /**
     * Set binaryObject value
     * @param \StructType\Base64Binary $binaryObject
     * @return \StructType\AttachmentType
     */
    public function setBinaryObject(\StructType\Base64Binary $binaryObject = null)
    {
        $this->binaryObject = $binaryObject;
        return $this;
    }
    /**
     * Get documentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->documentNumber;
    }
    /**
     * Set documentNumber value
     * @param string $documentNumber
     * @return \StructType\AttachmentType
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($documentNumber) && strlen($documentNumber) > 9) || (is_array($documentNumber) && count($documentNumber) > 9)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s) at most, "%d" length given', is_scalar($documentNumber) ? strlen($documentNumber) : count($documentNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($documentNumber) && strlen($documentNumber) < 1) || (is_array($documentNumber) && count($documentNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($documentNumber) && !preg_match('/[A-Z0-9\\.]*/', $documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.]*", "%s" given', var_export($documentNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentNumber)), __LINE__);
        }
        $this->documentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\AttachmentType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 200) || (is_array($name) && count($name) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($name) && !preg_match('/[A-Z0-9\\.\\\\!\\(\\):;\\?\',\\-&"=$%#\\|\/_\\{\\}\\*@ ]*/', $name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z0-9\.\\!\(\):;\?\',\-&"=$%#\|/_\{\}\*@ ]*", "%s" given', var_export($name, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\AttachmentType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 60) || (is_array($description) && count($description) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\AttachmentType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttachmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
