<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associate StructType
 * @subpackage Structs
 */
class Associate extends AbstractStructBase
{
    /**
     * The legalName
     * @var \StructType\LegalName
     */
    public $legalName;
    /**
     * The relationship
     * Meta informations extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \StructType\Relationship[]
     */
    public $relationship;
    /**
     * Constructor method for associate
     * @uses Associate::setLegalName()
     * @uses Associate::setRelationship()
     * @param \StructType\LegalName $legalName
     * @param \StructType\Relationship[] $relationship
     */
    public function __construct(\StructType\LegalName $legalName = null, array $relationship = array())
    {
        $this
            ->setLegalName($legalName)
            ->setRelationship($relationship);
    }
    /**
     * Get legalName value
     * @return \StructType\LegalName|null
     */
    public function getLegalName()
    {
        return $this->legalName;
    }
    /**
     * Set legalName value
     * @param \StructType\LegalName $legalName
     * @return \StructType\Associate
     */
    public function setLegalName(\StructType\LegalName $legalName = null)
    {
        $this->legalName = $legalName;
        return $this;
    }
    /**
     * Get relationship value
     * @return \StructType\Relationship[]|null
     */
    public function getRelationship()
    {
        return $this->relationship;
    }
    /**
     * Set relationship value
     * @throws \InvalidArgumentException
     * @param \StructType\Relationship[] $relationship
     * @return \StructType\Associate
     */
    public function setRelationship(array $relationship = array())
    {
        foreach ($relationship as $associateRelationshipItem) {
            // validation for constraint: itemType
            if (!$associateRelationshipItem instanceof \StructType\Relationship) {
                throw new \InvalidArgumentException(sprintf('The relationship property can only contain items of \StructType\Relationship, "%s" given', is_object($associateRelationshipItem) ? get_class($associateRelationshipItem) : gettype($associateRelationshipItem)), __LINE__);
            }
        }
        $this->relationship = $relationship;
        return $this;
    }
    /**
     * Add item to relationship value
     * @throws \InvalidArgumentException
     * @param \StructType\Relationship $item
     * @return \StructType\Associate
     */
    public function addToRelationship(\StructType\Relationship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Relationship) {
            throw new \InvalidArgumentException(sprintf('The relationship property can only contain items of \StructType\Relationship, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->relationship[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Associate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
