<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for agent StructType
 * Meta informations extracted from the WSDL
 * - documentation: ~Internal~
 * @subpackage Structs
 */
class Agent extends AbstractStructBase
{
    /**
     * The account
     * Meta informations extracted from the WSDL
     * - documentation: acts for customer
     * - minOccurs: 0
     * @var \StructType\FssAccountType
     */
    public $account;
    /**
     * The removeAgent
     * Meta informations extracted from the WSDL
     * - documentation: only valid for updates
     * - minOccurs: 0
     * @var bool
     */
    public $removeAgent;
    /**
     * The manager
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 40
     * @var string
     */
    public $manager;
    /**
     * The agentNo
     * Meta informations extracted from the WSDL
     * - documentation: Internal Ascot Ids ie N9
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $agentNo;
    /**
     * The agentName
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $agentName;
    /**
     * Constructor method for agent
     * @uses Agent::setAccount()
     * @uses Agent::setRemoveAgent()
     * @uses Agent::setManager()
     * @uses Agent::setAgentNo()
     * @uses Agent::setAgentName()
     * @param \StructType\FssAccountType $account
     * @param bool $removeAgent
     * @param string $manager
     * @param int $agentNo
     * @param string $agentName
     */
    public function __construct(\StructType\FssAccountType $account = null, $removeAgent = null, $manager = null, $agentNo = null, $agentName = null)
    {
        $this
            ->setAccount($account)
            ->setRemoveAgent($removeAgent)
            ->setManager($manager)
            ->setAgentNo($agentNo)
            ->setAgentName($agentName);
    }
    /**
     * Get account value
     * @return \StructType\FssAccountType|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\FssAccountType $account
     * @return \StructType\Agent
     */
    public function setAccount(\StructType\FssAccountType $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get removeAgent value
     * @return bool|null
     */
    public function getRemoveAgent()
    {
        return $this->removeAgent;
    }
    /**
     * Set removeAgent value
     * @param bool $removeAgent
     * @return \StructType\Agent
     */
    public function setRemoveAgent($removeAgent = null)
    {
        // validation for constraint: boolean
        if (!is_null($removeAgent) && !is_bool($removeAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($removeAgent)), __LINE__);
        }
        $this->removeAgent = $removeAgent;
        return $this;
    }
    /**
     * Get manager value
     * @return string|null
     */
    public function getManager()
    {
        return $this->manager;
    }
    /**
     * Set manager value
     * @param string $manager
     * @return \StructType\Agent
     */
    public function setManager($manager = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($manager) && strlen($manager) > 40) || (is_array($manager) && count($manager) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($manager) ? strlen($manager) : count($manager)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($manager) && !is_string($manager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manager)), __LINE__);
        }
        $this->manager = $manager;
        return $this;
    }
    /**
     * Get agentNo value
     * @return int|null
     */
    public function getAgentNo()
    {
        return $this->agentNo;
    }
    /**
     * Set agentNo value
     * @param int $agentNo
     * @return \StructType\Agent
     */
    public function setAgentNo($agentNo = null)
    {
        // validation for constraint: maxInclusive
        if ($agentNo > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $agentNo), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($agentNo < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $agentNo), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($agentNo) && !is_numeric($agentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($agentNo)), __LINE__);
        }
        $this->agentNo = $agentNo;
        return $this;
    }
    /**
     * Get agentName value
     * @return string|null
     */
    public function getAgentName()
    {
        return $this->agentName;
    }
    /**
     * Set agentName value
     * @param string $agentName
     * @return \StructType\Agent
     */
    public function setAgentName($agentName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($agentName) && strlen($agentName) > 200) || (is_array($agentName) && count($agentName) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($agentName) ? strlen($agentName) : count($agentName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($agentName) && !is_string($agentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentName)), __LINE__);
        }
        $this->agentName = $agentName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Agent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
