<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for actionType StructType
 * @subpackage Structs
 */
class ActionType extends AbstractStructBase
{
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The effectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $effectiveDate;
    /**
     * Constructor method for actionType
     * @uses ActionType::setCode()
     * @uses ActionType::setEffectiveDate()
     * @param string $code
     * @param string $effectiveDate
     */
    public function __construct($code = null, $effectiveDate = null)
    {
        $this
            ->setCode($code)
            ->setEffectiveDate($effectiveDate);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @uses \EnumType\Code::valueIsValid()
     * @uses \EnumType\Code::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\ActionType
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Code::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $code, implode(', ', \EnumType\Code::getValidValues())), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get effectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->effectiveDate;
    }
    /**
     * Set effectiveDate value
     * @param string $effectiveDate
     * @return \StructType\ActionType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: minInclusive
        if ($effectiveDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $effectiveDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->effectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
