<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for accountIdentifierType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Identity for an account.
 * @subpackage Structs
 */
class AccountIdentifierType extends RealmIdentifierType
{
    /**
     * The accountIdentifier
     * Meta informations extracted from the WSDL
     * - maxLength: 128
     * @var string
     */
    public $accountIdentifier;
    /**
     * Constructor method for accountIdentifierType
     * @uses AccountIdentifierType::setAccountIdentifier()
     * @param string $accountIdentifier
     */
    public function __construct($accountIdentifier = null)
    {
        $this
            ->setAccountIdentifier($accountIdentifier);
    }
    /**
     * Get accountIdentifier value
     * @return string|null
     */
    public function getAccountIdentifier()
    {
        return $this->accountIdentifier;
    }
    /**
     * Set accountIdentifier value
     * @param string $accountIdentifier
     * @return \StructType\AccountIdentifierType
     */
    public function setAccountIdentifier($accountIdentifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($accountIdentifier) && strlen($accountIdentifier) > 128) || (is_array($accountIdentifier) && count($accountIdentifier) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($accountIdentifier) ? strlen($accountIdentifier) : count($accountIdentifier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($accountIdentifier) && !is_string($accountIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountIdentifier)), __LINE__);
        }
        $this->accountIdentifier = $accountIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountIdentifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
