<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for abrEntityType StructType
 * Meta informations extracted from the WSDL
 * - documentation: ABR fields used to determine how the business entity is stored
 * @subpackage Structs
 */
class AbrEntityType extends AbstractStructBase
{
    /**
     * The abn
     * Meta informations extracted from the WSDL
     * - documentation: ABN as 99999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: ([0-9]{11})
     * @var string
     */
    public $abn;
    /**
     * The abnReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxInclusive: 99999999999999
     * - minInclusive: 1
     * @var int
     */
    public $abnReferenceNumber;
    /**
     * The entityName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $entityName;
    /**
     * The entityType
     * Meta informations extracted from the WSDL
     * - documentation: Abr entity type
     * - minOccurs: 0
     * - maxLength: 3
     * @var string
     */
    public $entityType;
    /**
     * The effectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $effectiveDate;
    /**
     * Constructor method for abrEntityType
     * @uses AbrEntityType::setAbn()
     * @uses AbrEntityType::setAbnReferenceNumber()
     * @uses AbrEntityType::setEntityName()
     * @uses AbrEntityType::setEntityType()
     * @uses AbrEntityType::setEffectiveDate()
     * @param string $abn
     * @param int $abnReferenceNumber
     * @param string $entityName
     * @param string $entityType
     * @param string $effectiveDate
     */
    public function __construct($abn = null, $abnReferenceNumber = null, $entityName = null, $entityType = null, $effectiveDate = null)
    {
        $this
            ->setAbn($abn)
            ->setAbnReferenceNumber($abnReferenceNumber)
            ->setEntityName($entityName)
            ->setEntityType($entityType)
            ->setEffectiveDate($effectiveDate);
    }
    /**
     * Get abn value
     * @return string|null
     */
    public function getAbn()
    {
        return $this->abn;
    }
    /**
     * Set abn value
     * @param string $abn
     * @return \StructType\AbrEntityType
     */
    public function setAbn($abn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abn) && strlen($abn) > 11) || (is_array($abn) && count($abn) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($abn) ? strlen($abn) : count($abn)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($abn) && strlen($abn) < 11) || (is_array($abn) && count($abn) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($abn) && !preg_match('/([0-9]{11})/', $abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{11})", "%s" given', var_export($abn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abn) && !is_string($abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abn)), __LINE__);
        }
        $this->abn = $abn;
        return $this;
    }
    /**
     * Get abnReferenceNumber value
     * @return int|null
     */
    public function getAbnReferenceNumber()
    {
        return $this->abnReferenceNumber;
    }
    /**
     * Set abnReferenceNumber value
     * @param int $abnReferenceNumber
     * @return \StructType\AbrEntityType
     */
    public function setAbnReferenceNumber($abnReferenceNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($abnReferenceNumber > 99999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999999999999, "%s" given', $abnReferenceNumber), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($abnReferenceNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $abnReferenceNumber), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($abnReferenceNumber) && !is_numeric($abnReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($abnReferenceNumber)), __LINE__);
        }
        $this->abnReferenceNumber = $abnReferenceNumber;
        return $this;
    }
    /**
     * Get entityName value
     * @return string|null
     */
    public function getEntityName()
    {
        return $this->entityName;
    }
    /**
     * Set entityName value
     * @param string $entityName
     * @return \StructType\AbrEntityType
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($entityName) && strlen($entityName) > 200) || (is_array($entityName) && count($entityName) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($entityName) ? strlen($entityName) : count($entityName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityName)), __LINE__);
        }
        $this->entityName = $entityName;
        return $this;
    }
    /**
     * Get entityType value
     * @return string|null
     */
    public function getEntityType()
    {
        return $this->entityType;
    }
    /**
     * Set entityType value
     * @param string $entityType
     * @return \StructType\AbrEntityType
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($entityType) && strlen($entityType) > 3) || (is_array($entityType) && count($entityType) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($entityType) ? strlen($entityType) : count($entityType)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityType)), __LINE__);
        }
        $this->entityType = $entityType;
        return $this;
    }
    /**
     * Get effectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->effectiveDate;
    }
    /**
     * Set effectiveDate value
     * @param string $effectiveDate
     * @return \StructType\AbrEntityType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: minInclusive
        if ($effectiveDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $effectiveDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->effectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbrEntityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
