<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for abnUpdateType StructType
 * @subpackage Structs
 */
class AbnUpdateType extends AbstractStructBase
{
    /**
     * The action
     * @var string
     */
    public $action;
    /**
     * The abnReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxInclusive: 99999999999999
     * - totalDigits: 13
     * @var int
     */
    public $abnReferenceNumber;
    /**
     * The abn
     * Meta informations extracted from the WSDL
     * - documentation: ABN as 99999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: ([0-9]{11})
     * @var string
     */
    public $abn;
    /**
     * The nniNumber
     * Meta informations extracted from the WSDL
     * - maxInclusive: 999999999
     * - minInclusive: 1
     * @var int
     */
    public $nniNumber;
    /**
     * The abrEntity
     * Meta informations extracted from the WSDL
     * - documentation: For action = APROVED, CHANGED
     * - minOccurs: 0
     * @var \StructType\BaseAbrEntityType
     */
    public $abrEntity;
    /**
     * Constructor method for abnUpdateType
     * @uses AbnUpdateType::setAction()
     * @uses AbnUpdateType::setAbnReferenceNumber()
     * @uses AbnUpdateType::setAbn()
     * @uses AbnUpdateType::setNniNumber()
     * @uses AbnUpdateType::setAbrEntity()
     * @param string $action
     * @param int $abnReferenceNumber
     * @param string $abn
     * @param int $nniNumber
     * @param \StructType\BaseAbrEntityType $abrEntity
     */
    public function __construct($action = null, $abnReferenceNumber = null, $abn = null, $nniNumber = null, \StructType\BaseAbrEntityType $abrEntity = null)
    {
        $this
            ->setAction($action)
            ->setAbnReferenceNumber($abnReferenceNumber)
            ->setAbn($abn)
            ->setNniNumber($nniNumber)
            ->setAbrEntity($abrEntity);
    }
    /**
     * Get action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @uses \EnumType\Action::valueIsValid()
     * @uses \EnumType\Action::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \StructType\AbnUpdateType
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Action::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \EnumType\Action::getValidValues())), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get abnReferenceNumber value
     * @return int|null
     */
    public function getAbnReferenceNumber()
    {
        return $this->abnReferenceNumber;
    }
    /**
     * Set abnReferenceNumber value
     * @param int $abnReferenceNumber
     * @return \StructType\AbnUpdateType
     */
    public function setAbnReferenceNumber($abnReferenceNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($abnReferenceNumber > 99999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999999999999, "%s" given', $abnReferenceNumber), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($abnReferenceNumber) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $abnReferenceNumber)) !== 13) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 13 digits, "%d" given', strlen(substr($abnReferenceNumber, strpos($abnReferenceNumber, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($abnReferenceNumber) && !is_numeric($abnReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($abnReferenceNumber)), __LINE__);
        }
        $this->abnReferenceNumber = $abnReferenceNumber;
        return $this;
    }
    /**
     * Get abn value
     * @return string|null
     */
    public function getAbn()
    {
        return $this->abn;
    }
    /**
     * Set abn value
     * @param string $abn
     * @return \StructType\AbnUpdateType
     */
    public function setAbn($abn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abn) && strlen($abn) > 11) || (is_array($abn) && count($abn) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($abn) ? strlen($abn) : count($abn)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($abn) && strlen($abn) < 11) || (is_array($abn) && count($abn) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($abn) && !preg_match('/([0-9]{11})/', $abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{11})", "%s" given', var_export($abn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abn) && !is_string($abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abn)), __LINE__);
        }
        $this->abn = $abn;
        return $this;
    }
    /**
     * Get nniNumber value
     * @return int|null
     */
    public function getNniNumber()
    {
        return $this->nniNumber;
    }
    /**
     * Set nniNumber value
     * @param int $nniNumber
     * @return \StructType\AbnUpdateType
     */
    public function setNniNumber($nniNumber = null)
    {
        // validation for constraint: maxInclusive
        if ($nniNumber > 999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999, "%s" given', $nniNumber), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($nniNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $nniNumber), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($nniNumber) && !is_numeric($nniNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nniNumber)), __LINE__);
        }
        $this->nniNumber = $nniNumber;
        return $this;
    }
    /**
     * Get abrEntity value
     * @return \StructType\BaseAbrEntityType|null
     */
    public function getAbrEntity()
    {
        return $this->abrEntity;
    }
    /**
     * Set abrEntity value
     * @param \StructType\BaseAbrEntityType $abrEntity
     * @return \StructType\AbnUpdateType
     */
    public function setAbrEntity(\StructType\BaseAbrEntityType $abrEntity = null)
    {
        $this->abrEntity = $abrEntity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbnUpdateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
