<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for abnRecordType StructType
 * @subpackage Structs
 */
class AbnRecordType extends AbstractStructBase
{
    /**
     * The ABN
     * Meta informations extracted from the WSDL
     * - documentation: The ABN is the Australian Business Number allocated to the entity.
     * - maxOccurs: 100
     * @var \StructType\IdentifierType[]
     */
    public $ABN;
    /**
     * The ACN
     * Meta informations extracted from the WSDL
     * - documentation: ACN/ARBN Value.
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \StructType\IdentifierType[]
     */
    public $ACN;
    /**
     * The ANZSIC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \StructType\ANZSIC[]
     */
    public $ANZSIC;
    /**
     * The entityType
     * Meta informations extracted from the WSDL
     * - documentation: The entityType describes the specific type of the party (e.g. family partnership, individual/sole trader). This is the publicly releasable entity type.
     * - maxOccurs: 100
     * - minOccurs: 0
     * - maxLength: 4
     * @var string[]
     */
    public $entityType;
    /**
     * The goodsAndServicesTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \StructType\GoodsAndServicesTax[]
     */
    public $goodsAndServicesTax;
    /**
     * The deductibleGiftRecipient
     * Meta informations extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \StructType\DeductibleGiftRecipient[]
     */
    public $deductibleGiftRecipient;
    /**
     * The legalName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \StructType\LegalName[]
     */
    public $legalName;
    /**
     * The mainTradingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \StructType\MainTradingName[]
     */
    public $mainTradingName;
    /**
     * The otherTradingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \StructType\OtherTradingName[]
     */
    public $otherTradingName;
    /**
     * The serviceOfNoticePhysicalAddress
     * Meta informations extracted from the WSDL
     * - documentation: The serviceOfNoticePhysicalAddress describes the address to which notices may be served.
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \StructType\GeographicType[]
     */
    public $serviceOfNoticePhysicalAddress;
    /**
     * The serviceOfNoticeEmailAddress
     * Meta informations extracted from the WSDL
     * - documentation: The serviceOfNoticeEmailAddress describes the email address to which notices may be served.
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \StructType\AbnEmailType[]
     */
    public $serviceOfNoticeEmailAddress;
    /**
     * The mainBusinessPhysicalAddress
     * Meta informations extracted from the WSDL
     * - documentation: The mainBusinessPhysicalAddress is the main physical address of the organisation.
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \StructType\GeographicType[]
     */
    public $mainBusinessPhysicalAddress;
    /**
     * The associate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \StructType\Associate[]
     */
    public $associate;
    /**
     * The suppressionIndicator
     * Meta informations extracted from the WSDL
     * - documentation: The supressionIndicator desicribes whether or not the record has been supresed.
     * - minOccurs: 0
     * @var string
     */
    public $suppressionIndicator;
    /**
     * Constructor method for abnRecordType
     * @uses AbnRecordType::setABN()
     * @uses AbnRecordType::setACN()
     * @uses AbnRecordType::setANZSIC()
     * @uses AbnRecordType::setEntityType()
     * @uses AbnRecordType::setGoodsAndServicesTax()
     * @uses AbnRecordType::setDeductibleGiftRecipient()
     * @uses AbnRecordType::setLegalName()
     * @uses AbnRecordType::setMainTradingName()
     * @uses AbnRecordType::setOtherTradingName()
     * @uses AbnRecordType::setServiceOfNoticePhysicalAddress()
     * @uses AbnRecordType::setServiceOfNoticeEmailAddress()
     * @uses AbnRecordType::setMainBusinessPhysicalAddress()
     * @uses AbnRecordType::setAssociate()
     * @uses AbnRecordType::setSuppressionIndicator()
     * @param \StructType\IdentifierType[] $aBN
     * @param \StructType\IdentifierType[] $aCN
     * @param \StructType\ANZSIC[] $aNZSIC
     * @param string[] $entityType
     * @param \StructType\GoodsAndServicesTax[] $goodsAndServicesTax
     * @param \StructType\DeductibleGiftRecipient[] $deductibleGiftRecipient
     * @param \StructType\LegalName[] $legalName
     * @param \StructType\MainTradingName[] $mainTradingName
     * @param \StructType\OtherTradingName[] $otherTradingName
     * @param \StructType\GeographicType[] $serviceOfNoticePhysicalAddress
     * @param \StructType\AbnEmailType[] $serviceOfNoticeEmailAddress
     * @param \StructType\GeographicType[] $mainBusinessPhysicalAddress
     * @param \StructType\Associate[] $associate
     * @param string $suppressionIndicator
     */
    public function __construct(array $aBN = array(), array $aCN = array(), array $aNZSIC = array(), array $entityType = array(), array $goodsAndServicesTax = array(), array $deductibleGiftRecipient = array(), array $legalName = array(), array $mainTradingName = array(), array $otherTradingName = array(), array $serviceOfNoticePhysicalAddress = array(), array $serviceOfNoticeEmailAddress = array(), array $mainBusinessPhysicalAddress = array(), array $associate = array(), $suppressionIndicator = null)
    {
        $this
            ->setABN($aBN)
            ->setACN($aCN)
            ->setANZSIC($aNZSIC)
            ->setEntityType($entityType)
            ->setGoodsAndServicesTax($goodsAndServicesTax)
            ->setDeductibleGiftRecipient($deductibleGiftRecipient)
            ->setLegalName($legalName)
            ->setMainTradingName($mainTradingName)
            ->setOtherTradingName($otherTradingName)
            ->setServiceOfNoticePhysicalAddress($serviceOfNoticePhysicalAddress)
            ->setServiceOfNoticeEmailAddress($serviceOfNoticeEmailAddress)
            ->setMainBusinessPhysicalAddress($mainBusinessPhysicalAddress)
            ->setAssociate($associate)
            ->setSuppressionIndicator($suppressionIndicator);
    }
    /**
     * Get ABN value
     * @return \StructType\IdentifierType[]|null
     */
    public function getABN()
    {
        return $this->ABN;
    }
    /**
     * Set ABN value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierType[] $aBN
     * @return \StructType\AbnRecordType
     */
    public function setABN(array $aBN = array())
    {
        foreach ($aBN as $abnRecordTypeABNItem) {
            // validation for constraint: itemType
            if (!$abnRecordTypeABNItem instanceof \StructType\IdentifierType) {
                throw new \InvalidArgumentException(sprintf('The ABN property can only contain items of \StructType\IdentifierType, "%s" given', is_object($abnRecordTypeABNItem) ? get_class($abnRecordTypeABNItem) : gettype($abnRecordTypeABNItem)), __LINE__);
            }
        }
        $this->ABN = $aBN;
        return $this;
    }
    /**
     * Add item to ABN value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierType $item
     * @return \StructType\AbnRecordType
     */
    public function addToABN(\StructType\IdentifierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentifierType) {
            throw new \InvalidArgumentException(sprintf('The ABN property can only contain items of \StructType\IdentifierType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ABN[] = $item;
        return $this;
    }
    /**
     * Get ACN value
     * @return \StructType\IdentifierType[]|null
     */
    public function getACN()
    {
        return $this->ACN;
    }
    /**
     * Set ACN value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierType[] $aCN
     * @return \StructType\AbnRecordType
     */
    public function setACN(array $aCN = array())
    {
        foreach ($aCN as $abnRecordTypeACNItem) {
            // validation for constraint: itemType
            if (!$abnRecordTypeACNItem instanceof \StructType\IdentifierType) {
                throw new \InvalidArgumentException(sprintf('The ACN property can only contain items of \StructType\IdentifierType, "%s" given', is_object($abnRecordTypeACNItem) ? get_class($abnRecordTypeACNItem) : gettype($abnRecordTypeACNItem)), __LINE__);
            }
        }
        $this->ACN = $aCN;
        return $this;
    }
    /**
     * Add item to ACN value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierType $item
     * @return \StructType\AbnRecordType
     */
    public function addToACN(\StructType\IdentifierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentifierType) {
            throw new \InvalidArgumentException(sprintf('The ACN property can only contain items of \StructType\IdentifierType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ACN[] = $item;
        return $this;
    }
    /**
     * Get ANZSIC value
     * @return \StructType\ANZSIC[]|null
     */
    public function getANZSIC()
    {
        return $this->ANZSIC;
    }
    /**
     * Set ANZSIC value
     * @throws \InvalidArgumentException
     * @param \StructType\ANZSIC[] $aNZSIC
     * @return \StructType\AbnRecordType
     */
    public function setANZSIC(array $aNZSIC = array())
    {
        foreach ($aNZSIC as $abnRecordTypeANZSICItem) {
            // validation for constraint: itemType
            if (!$abnRecordTypeANZSICItem instanceof \StructType\ANZSIC) {
                throw new \InvalidArgumentException(sprintf('The ANZSIC property can only contain items of \StructType\ANZSIC, "%s" given', is_object($abnRecordTypeANZSICItem) ? get_class($abnRecordTypeANZSICItem) : gettype($abnRecordTypeANZSICItem)), __LINE__);
            }
        }
        $this->ANZSIC = $aNZSIC;
        return $this;
    }
    /**
     * Add item to ANZSIC value
     * @throws \InvalidArgumentException
     * @param \StructType\ANZSIC $item
     * @return \StructType\AbnRecordType
     */
    public function addToANZSIC(\StructType\ANZSIC $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ANZSIC) {
            throw new \InvalidArgumentException(sprintf('The ANZSIC property can only contain items of \StructType\ANZSIC, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ANZSIC[] = $item;
        return $this;
    }
    /**
     * Get entityType value
     * @return string[]|null
     */
    public function getEntityType()
    {
        return $this->entityType;
    }
    /**
     * Set entityType value
     * @throws \InvalidArgumentException
     * @param string[] $entityType
     * @return \StructType\AbnRecordType
     */
    public function setEntityType(array $entityType = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($entityType) && strlen($entityType) > 4) || (is_array($entityType) && count($entityType) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($entityType) ? strlen($entityType) : count($entityType)), __LINE__);
        }
        foreach ($entityType as $abnRecordTypeEntityTypeItem) {
            // validation for constraint: itemType
            if (!is_string($abnRecordTypeEntityTypeItem)) {
                throw new \InvalidArgumentException(sprintf('The entityType property can only contain items of string, "%s" given', is_object($abnRecordTypeEntityTypeItem) ? get_class($abnRecordTypeEntityTypeItem) : gettype($abnRecordTypeEntityTypeItem)), __LINE__);
            }
        }
        $this->entityType = $entityType;
        return $this;
    }
    /**
     * Add item to entityType value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AbnRecordType
     */
    public function addToEntityType($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 4) || (is_array($item) && count($item) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The entityType property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->entityType[] = $item;
        return $this;
    }
    /**
     * Get goodsAndServicesTax value
     * @return \StructType\GoodsAndServicesTax[]|null
     */
    public function getGoodsAndServicesTax()
    {
        return $this->goodsAndServicesTax;
    }
    /**
     * Set goodsAndServicesTax value
     * @throws \InvalidArgumentException
     * @param \StructType\GoodsAndServicesTax[] $goodsAndServicesTax
     * @return \StructType\AbnRecordType
     */
    public function setGoodsAndServicesTax(array $goodsAndServicesTax = array())
    {
        foreach ($goodsAndServicesTax as $abnRecordTypeGoodsAndServicesTaxItem) {
            // validation for constraint: itemType
            if (!$abnRecordTypeGoodsAndServicesTaxItem instanceof \StructType\GoodsAndServicesTax) {
                throw new \InvalidArgumentException(sprintf('The goodsAndServicesTax property can only contain items of \StructType\GoodsAndServicesTax, "%s" given', is_object($abnRecordTypeGoodsAndServicesTaxItem) ? get_class($abnRecordTypeGoodsAndServicesTaxItem) : gettype($abnRecordTypeGoodsAndServicesTaxItem)), __LINE__);
            }
        }
        $this->goodsAndServicesTax = $goodsAndServicesTax;
        return $this;
    }
    /**
     * Add item to goodsAndServicesTax value
     * @throws \InvalidArgumentException
     * @param \StructType\GoodsAndServicesTax $item
     * @return \StructType\AbnRecordType
     */
    public function addToGoodsAndServicesTax(\StructType\GoodsAndServicesTax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GoodsAndServicesTax) {
            throw new \InvalidArgumentException(sprintf('The goodsAndServicesTax property can only contain items of \StructType\GoodsAndServicesTax, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->goodsAndServicesTax[] = $item;
        return $this;
    }
    /**
     * Get deductibleGiftRecipient value
     * @return \StructType\DeductibleGiftRecipient[]|null
     */
    public function getDeductibleGiftRecipient()
    {
        return $this->deductibleGiftRecipient;
    }
    /**
     * Set deductibleGiftRecipient value
     * @throws \InvalidArgumentException
     * @param \StructType\DeductibleGiftRecipient[] $deductibleGiftRecipient
     * @return \StructType\AbnRecordType
     */
    public function setDeductibleGiftRecipient(array $deductibleGiftRecipient = array())
    {
        foreach ($deductibleGiftRecipient as $abnRecordTypeDeductibleGiftRecipientItem) {
            // validation for constraint: itemType
            if (!$abnRecordTypeDeductibleGiftRecipientItem instanceof \StructType\DeductibleGiftRecipient) {
                throw new \InvalidArgumentException(sprintf('The deductibleGiftRecipient property can only contain items of \StructType\DeductibleGiftRecipient, "%s" given', is_object($abnRecordTypeDeductibleGiftRecipientItem) ? get_class($abnRecordTypeDeductibleGiftRecipientItem) : gettype($abnRecordTypeDeductibleGiftRecipientItem)), __LINE__);
            }
        }
        $this->deductibleGiftRecipient = $deductibleGiftRecipient;
        return $this;
    }
    /**
     * Add item to deductibleGiftRecipient value
     * @throws \InvalidArgumentException
     * @param \StructType\DeductibleGiftRecipient $item
     * @return \StructType\AbnRecordType
     */
    public function addToDeductibleGiftRecipient(\StructType\DeductibleGiftRecipient $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeductibleGiftRecipient) {
            throw new \InvalidArgumentException(sprintf('The deductibleGiftRecipient property can only contain items of \StructType\DeductibleGiftRecipient, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->deductibleGiftRecipient[] = $item;
        return $this;
    }
    /**
     * Get legalName value
     * @return \StructType\LegalName[]|null
     */
    public function getLegalName()
    {
        return $this->legalName;
    }
    /**
     * Set legalName value
     * @throws \InvalidArgumentException
     * @param \StructType\LegalName[] $legalName
     * @return \StructType\AbnRecordType
     */
    public function setLegalName(array $legalName = array())
    {
        foreach ($legalName as $abnRecordTypeLegalNameItem) {
            // validation for constraint: itemType
            if (!$abnRecordTypeLegalNameItem instanceof \StructType\LegalName) {
                throw new \InvalidArgumentException(sprintf('The legalName property can only contain items of \StructType\LegalName, "%s" given', is_object($abnRecordTypeLegalNameItem) ? get_class($abnRecordTypeLegalNameItem) : gettype($abnRecordTypeLegalNameItem)), __LINE__);
            }
        }
        $this->legalName = $legalName;
        return $this;
    }
    /**
     * Add item to legalName value
     * @throws \InvalidArgumentException
     * @param \StructType\LegalName $item
     * @return \StructType\AbnRecordType
     */
    public function addToLegalName(\StructType\LegalName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LegalName) {
            throw new \InvalidArgumentException(sprintf('The legalName property can only contain items of \StructType\LegalName, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->legalName[] = $item;
        return $this;
    }
    /**
     * Get mainTradingName value
     * @return \StructType\MainTradingName[]|null
     */
    public function getMainTradingName()
    {
        return $this->mainTradingName;
    }
    /**
     * Set mainTradingName value
     * @throws \InvalidArgumentException
     * @param \StructType\MainTradingName[] $mainTradingName
     * @return \StructType\AbnRecordType
     */
    public function setMainTradingName(array $mainTradingName = array())
    {
        foreach ($mainTradingName as $abnRecordTypeMainTradingNameItem) {
            // validation for constraint: itemType
            if (!$abnRecordTypeMainTradingNameItem instanceof \StructType\MainTradingName) {
                throw new \InvalidArgumentException(sprintf('The mainTradingName property can only contain items of \StructType\MainTradingName, "%s" given', is_object($abnRecordTypeMainTradingNameItem) ? get_class($abnRecordTypeMainTradingNameItem) : gettype($abnRecordTypeMainTradingNameItem)), __LINE__);
            }
        }
        $this->mainTradingName = $mainTradingName;
        return $this;
    }
    /**
     * Add item to mainTradingName value
     * @throws \InvalidArgumentException
     * @param \StructType\MainTradingName $item
     * @return \StructType\AbnRecordType
     */
    public function addToMainTradingName(\StructType\MainTradingName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MainTradingName) {
            throw new \InvalidArgumentException(sprintf('The mainTradingName property can only contain items of \StructType\MainTradingName, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->mainTradingName[] = $item;
        return $this;
    }
    /**
     * Get otherTradingName value
     * @return \StructType\OtherTradingName[]|null
     */
    public function getOtherTradingName()
    {
        return $this->otherTradingName;
    }
    /**
     * Set otherTradingName value
     * @throws \InvalidArgumentException
     * @param \StructType\OtherTradingName[] $otherTradingName
     * @return \StructType\AbnRecordType
     */
    public function setOtherTradingName(array $otherTradingName = array())
    {
        foreach ($otherTradingName as $abnRecordTypeOtherTradingNameItem) {
            // validation for constraint: itemType
            if (!$abnRecordTypeOtherTradingNameItem instanceof \StructType\OtherTradingName) {
                throw new \InvalidArgumentException(sprintf('The otherTradingName property can only contain items of \StructType\OtherTradingName, "%s" given', is_object($abnRecordTypeOtherTradingNameItem) ? get_class($abnRecordTypeOtherTradingNameItem) : gettype($abnRecordTypeOtherTradingNameItem)), __LINE__);
            }
        }
        $this->otherTradingName = $otherTradingName;
        return $this;
    }
    /**
     * Add item to otherTradingName value
     * @throws \InvalidArgumentException
     * @param \StructType\OtherTradingName $item
     * @return \StructType\AbnRecordType
     */
    public function addToOtherTradingName(\StructType\OtherTradingName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OtherTradingName) {
            throw new \InvalidArgumentException(sprintf('The otherTradingName property can only contain items of \StructType\OtherTradingName, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->otherTradingName[] = $item;
        return $this;
    }
    /**
     * Get serviceOfNoticePhysicalAddress value
     * @return \StructType\GeographicType[]|null
     */
    public function getServiceOfNoticePhysicalAddress()
    {
        return $this->serviceOfNoticePhysicalAddress;
    }
    /**
     * Set serviceOfNoticePhysicalAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\GeographicType[] $serviceOfNoticePhysicalAddress
     * @return \StructType\AbnRecordType
     */
    public function setServiceOfNoticePhysicalAddress(array $serviceOfNoticePhysicalAddress = array())
    {
        foreach ($serviceOfNoticePhysicalAddress as $abnRecordTypeServiceOfNoticePhysicalAddressItem) {
            // validation for constraint: itemType
            if (!$abnRecordTypeServiceOfNoticePhysicalAddressItem instanceof \StructType\GeographicType) {
                throw new \InvalidArgumentException(sprintf('The serviceOfNoticePhysicalAddress property can only contain items of \StructType\GeographicType, "%s" given', is_object($abnRecordTypeServiceOfNoticePhysicalAddressItem) ? get_class($abnRecordTypeServiceOfNoticePhysicalAddressItem) : gettype($abnRecordTypeServiceOfNoticePhysicalAddressItem)), __LINE__);
            }
        }
        $this->serviceOfNoticePhysicalAddress = $serviceOfNoticePhysicalAddress;
        return $this;
    }
    /**
     * Add item to serviceOfNoticePhysicalAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\GeographicType $item
     * @return \StructType\AbnRecordType
     */
    public function addToServiceOfNoticePhysicalAddress(\StructType\GeographicType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GeographicType) {
            throw new \InvalidArgumentException(sprintf('The serviceOfNoticePhysicalAddress property can only contain items of \StructType\GeographicType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->serviceOfNoticePhysicalAddress[] = $item;
        return $this;
    }
    /**
     * Get serviceOfNoticeEmailAddress value
     * @return \StructType\AbnEmailType[]|null
     */
    public function getServiceOfNoticeEmailAddress()
    {
        return $this->serviceOfNoticeEmailAddress;
    }
    /**
     * Set serviceOfNoticeEmailAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\AbnEmailType[] $serviceOfNoticeEmailAddress
     * @return \StructType\AbnRecordType
     */
    public function setServiceOfNoticeEmailAddress(array $serviceOfNoticeEmailAddress = array())
    {
        foreach ($serviceOfNoticeEmailAddress as $abnRecordTypeServiceOfNoticeEmailAddressItem) {
            // validation for constraint: itemType
            if (!$abnRecordTypeServiceOfNoticeEmailAddressItem instanceof \StructType\AbnEmailType) {
                throw new \InvalidArgumentException(sprintf('The serviceOfNoticeEmailAddress property can only contain items of \StructType\AbnEmailType, "%s" given', is_object($abnRecordTypeServiceOfNoticeEmailAddressItem) ? get_class($abnRecordTypeServiceOfNoticeEmailAddressItem) : gettype($abnRecordTypeServiceOfNoticeEmailAddressItem)), __LINE__);
            }
        }
        $this->serviceOfNoticeEmailAddress = $serviceOfNoticeEmailAddress;
        return $this;
    }
    /**
     * Add item to serviceOfNoticeEmailAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\AbnEmailType $item
     * @return \StructType\AbnRecordType
     */
    public function addToServiceOfNoticeEmailAddress(\StructType\AbnEmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AbnEmailType) {
            throw new \InvalidArgumentException(sprintf('The serviceOfNoticeEmailAddress property can only contain items of \StructType\AbnEmailType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->serviceOfNoticeEmailAddress[] = $item;
        return $this;
    }
    /**
     * Get mainBusinessPhysicalAddress value
     * @return \StructType\GeographicType[]|null
     */
    public function getMainBusinessPhysicalAddress()
    {
        return $this->mainBusinessPhysicalAddress;
    }
    /**
     * Set mainBusinessPhysicalAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\GeographicType[] $mainBusinessPhysicalAddress
     * @return \StructType\AbnRecordType
     */
    public function setMainBusinessPhysicalAddress(array $mainBusinessPhysicalAddress = array())
    {
        foreach ($mainBusinessPhysicalAddress as $abnRecordTypeMainBusinessPhysicalAddressItem) {
            // validation for constraint: itemType
            if (!$abnRecordTypeMainBusinessPhysicalAddressItem instanceof \StructType\GeographicType) {
                throw new \InvalidArgumentException(sprintf('The mainBusinessPhysicalAddress property can only contain items of \StructType\GeographicType, "%s" given', is_object($abnRecordTypeMainBusinessPhysicalAddressItem) ? get_class($abnRecordTypeMainBusinessPhysicalAddressItem) : gettype($abnRecordTypeMainBusinessPhysicalAddressItem)), __LINE__);
            }
        }
        $this->mainBusinessPhysicalAddress = $mainBusinessPhysicalAddress;
        return $this;
    }
    /**
     * Add item to mainBusinessPhysicalAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\GeographicType $item
     * @return \StructType\AbnRecordType
     */
    public function addToMainBusinessPhysicalAddress(\StructType\GeographicType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GeographicType) {
            throw new \InvalidArgumentException(sprintf('The mainBusinessPhysicalAddress property can only contain items of \StructType\GeographicType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->mainBusinessPhysicalAddress[] = $item;
        return $this;
    }
    /**
     * Get associate value
     * @return \StructType\Associate[]|null
     */
    public function getAssociate()
    {
        return $this->associate;
    }
    /**
     * Set associate value
     * @throws \InvalidArgumentException
     * @param \StructType\Associate[] $associate
     * @return \StructType\AbnRecordType
     */
    public function setAssociate(array $associate = array())
    {
        foreach ($associate as $abnRecordTypeAssociateItem) {
            // validation for constraint: itemType
            if (!$abnRecordTypeAssociateItem instanceof \StructType\Associate) {
                throw new \InvalidArgumentException(sprintf('The associate property can only contain items of \StructType\Associate, "%s" given', is_object($abnRecordTypeAssociateItem) ? get_class($abnRecordTypeAssociateItem) : gettype($abnRecordTypeAssociateItem)), __LINE__);
            }
        }
        $this->associate = $associate;
        return $this;
    }
    /**
     * Add item to associate value
     * @throws \InvalidArgumentException
     * @param \StructType\Associate $item
     * @return \StructType\AbnRecordType
     */
    public function addToAssociate(\StructType\Associate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Associate) {
            throw new \InvalidArgumentException(sprintf('The associate property can only contain items of \StructType\Associate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->associate[] = $item;
        return $this;
    }
    /**
     * Get suppressionIndicator value
     * @return string|null
     */
    public function getSuppressionIndicator()
    {
        return $this->suppressionIndicator;
    }
    /**
     * Set suppressionIndicator value
     * @uses \EnumType\IndicatorType::valueIsValid()
     * @uses \EnumType\IndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $suppressionIndicator
     * @return \StructType\AbnRecordType
     */
    public function setSuppressionIndicator($suppressionIndicator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IndicatorType::valueIsValid($suppressionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $suppressionIndicator, implode(', ', \EnumType\IndicatorType::getValidValues())), __LINE__);
        }
        $this->suppressionIndicator = $suppressionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbnRecordType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
