<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for abnEmailType StructType
 * @subpackage Structs
 */
class AbnEmailType extends AbstractStructBase
{
    /**
     * The effectiveFrom
     * @var string
     */
    public $effectiveFrom;
    /**
     * The effectiveTo
     * @var string
     */
    public $effectiveTo;
    /**
     * The deleteIndicator
     * @var string
     */
    public $deleteIndicator;
    /**
     * The emailAddress
     * Meta informations extracted from the WSDL
     * - documentation: email address
     * - maxLength: 200
     * @var string
     */
    public $emailAddress;
    /**
     * Constructor method for abnEmailType
     * @uses AbnEmailType::setEffectiveFrom()
     * @uses AbnEmailType::setEffectiveTo()
     * @uses AbnEmailType::setDeleteIndicator()
     * @uses AbnEmailType::setEmailAddress()
     * @param string $effectiveFrom
     * @param string $effectiveTo
     * @param string $deleteIndicator
     * @param string $emailAddress
     */
    public function __construct($effectiveFrom = null, $effectiveTo = null, $deleteIndicator = null, $emailAddress = null)
    {
        $this
            ->setEffectiveFrom($effectiveFrom)
            ->setEffectiveTo($effectiveTo)
            ->setDeleteIndicator($deleteIndicator)
            ->setEmailAddress($emailAddress);
    }
    /**
     * Get effectiveFrom value
     * @return string|null
     */
    public function getEffectiveFrom()
    {
        return $this->effectiveFrom;
    }
    /**
     * Set effectiveFrom value
     * @param string $effectiveFrom
     * @return \StructType\AbnEmailType
     */
    public function setEffectiveFrom($effectiveFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveFrom) && !is_string($effectiveFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveFrom)), __LINE__);
        }
        $this->effectiveFrom = $effectiveFrom;
        return $this;
    }
    /**
     * Get effectiveTo value
     * @return string|null
     */
    public function getEffectiveTo()
    {
        return $this->effectiveTo;
    }
    /**
     * Set effectiveTo value
     * @param string $effectiveTo
     * @return \StructType\AbnEmailType
     */
    public function setEffectiveTo($effectiveTo = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveTo) && !is_string($effectiveTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveTo)), __LINE__);
        }
        $this->effectiveTo = $effectiveTo;
        return $this;
    }
    /**
     * Get deleteIndicator value
     * @return string|null
     */
    public function getDeleteIndicator()
    {
        return $this->deleteIndicator;
    }
    /**
     * Set deleteIndicator value
     * @uses \EnumType\IndicatorType::valueIsValid()
     * @uses \EnumType\IndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deleteIndicator
     * @return \StructType\AbnEmailType
     */
    public function setDeleteIndicator($deleteIndicator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IndicatorType::valueIsValid($deleteIndicator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deleteIndicator, implode(', ', \EnumType\IndicatorType::getValidValues())), __LINE__);
        }
        $this->deleteIndicator = $deleteIndicator;
        return $this;
    }
    /**
     * Get emailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->emailAddress;
    }
    /**
     * Set emailAddress value
     * @param string $emailAddress
     * @return \StructType\AbnEmailType
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($emailAddress) && strlen($emailAddress) > 200) || (is_array($emailAddress) && count($emailAddress) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($emailAddress) ? strlen($emailAddress) : count($emailAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->emailAddress = $emailAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbnEmailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
