<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for External ServiceType
 * @subpackage Services
 */
class External extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named externalQueryNameAvailability
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\QueryNameAvailabilityRequestType $request
     * @return \StructType\QueryNameAvailabilityReplyType|bool
     */
    public function externalQueryNameAvailability(\StructType\QueryNameAvailabilityRequestType $request)
    {
        try {
            $this->setResult(self::getSoapClient()->externalQueryNameAvailability($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\QueryNameAvailabilityReplyType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
