<?php

namespace EnumType;

/**
 * This class stands for updateActionType EnumType
 * @subpackage Enumerations
 */
class UpdateActionType
{
    /**
     * Constant for value 'ADD'
     * @return string 'ADD'
     */
    const VALUE_ADD = 'ADD';
    /**
     * Constant for value 'CURRENT'
     * @return string 'CURRENT'
     */
    const VALUE_CURRENT = 'CURRENT';
    /**
     * Constant for value 'REMOVE'
     * @return string 'REMOVE'
     */
    const VALUE_REMOVE = 'REMOVE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADD
     * @uses self::VALUE_CURRENT
     * @uses self::VALUE_REMOVE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADD,
            self::VALUE_CURRENT,
            self::VALUE_REMOVE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
