<?php

namespace EnumType;

/**
 * This class stands for stateTerritoryCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Australian state or territory
 * @subpackage Enumerations
 */
class StateTerritoryCodeType
{
    /**
     * Constant for value 'ACT'
     * @return string 'ACT'
     */
    const VALUE_ACT = 'ACT';
    /**
     * Constant for value 'NSW'
     * @return string 'NSW'
     */
    const VALUE_NSW = 'NSW';
    /**
     * Constant for value 'NT'
     * @return string 'NT'
     */
    const VALUE_NT = 'NT';
    /**
     * Constant for value 'QLD'
     * @return string 'QLD'
     */
    const VALUE_QLD = 'QLD';
    /**
     * Constant for value 'SA'
     * @return string 'SA'
     */
    const VALUE_SA = 'SA';
    /**
     * Constant for value 'TAS'
     * @return string 'TAS'
     */
    const VALUE_TAS = 'TAS';
    /**
     * Constant for value 'WA'
     * @return string 'WA'
     */
    const VALUE_WA = 'WA';
    /**
     * Constant for value 'VIC'
     * @return string 'VIC'
     */
    const VALUE_VIC = 'VIC';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACT
     * @uses self::VALUE_NSW
     * @uses self::VALUE_NT
     * @uses self::VALUE_QLD
     * @uses self::VALUE_SA
     * @uses self::VALUE_TAS
     * @uses self::VALUE_WA
     * @uses self::VALUE_VIC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACT,
            self::VALUE_NSW,
            self::VALUE_NT,
            self::VALUE_QLD,
            self::VALUE_SA,
            self::VALUE_TAS,
            self::VALUE_WA,
            self::VALUE_VIC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
