<?php

namespace EnumType;

/**
 * This class stands for severity EnumType
 * @subpackage Enumerations
 */
class Severity
{
    /**
     * Constant for value 'Reject'
     * @return string 'Reject'
     */
    const VALUE_REJECT = 'Reject';
    /**
     * Constant for value 'Warning'
     * @return string 'Warning'
     */
    const VALUE_WARNING = 'Warning';
    /**
     * Constant for value 'Information'
     * @return string 'Information'
     */
    const VALUE_INFORMATION = 'Information';
    /**
     * Constant for value 'Pended'
     * @return string 'Pended'
     */
    const VALUE_PENDED = 'Pended';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REJECT
     * @uses self::VALUE_WARNING
     * @uses self::VALUE_INFORMATION
     * @uses self::VALUE_PENDED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REJECT,
            self::VALUE_WARNING,
            self::VALUE_INFORMATION,
            self::VALUE_PENDED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
