<?php

namespace EnumType;

/**
 * This class stands for searchType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: E ExactS Standard
 * @subpackage Enumerations
 */
class SearchType
{
    /**
     * Constant for value 'E'
     * @return string 'E'
     */
    const VALUE_E = 'E';
    /**
     * Constant for value 'S'
     * @return string 'S'
     */
    const VALUE_S = 'S';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_E
     * @uses self::VALUE_S
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_E,
            self::VALUE_S,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
