<?php

namespace EnumType;

/**
 * This class stands for representativeTypeType EnumType
 * @subpackage Enumerations
 */
class RepresentativeTypeType
{
    /**
     * Constant for value 'GG'
     * @return string 'GG'
     */
    const VALUE_GG = 'GG';
    /**
     * Constant for value 'GH'
     * @return string 'GH'
     */
    const VALUE_GH = 'GH';
    /**
     * Constant for value 'GI'
     * @return string 'GI'
     */
    const VALUE_GI = 'GI';
    /**
     * Constant for value 'GJ'
     * @return string 'GJ'
     */
    const VALUE_GJ = 'GJ';
    /**
     * Constant for value 'GK'
     * @return string 'GK'
     */
    const VALUE_GK = 'GK';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GG
     * @uses self::VALUE_GH
     * @uses self::VALUE_GI
     * @uses self::VALUE_GJ
     * @uses self::VALUE_GK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GG,
            self::VALUE_GH,
            self::VALUE_GI,
            self::VALUE_GJ,
            self::VALUE_GK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
