<?php

namespace EnumType;

/**
 * This class stands for paymentMethodType EnumType
 * @subpackage Enumerations
 */
class PaymentMethodType
{
    /**
     * Constant for value 'INV'
     * @return string 'INV'
     */
    const VALUE_INV = 'INV';
    /**
     * Constant for value 'CC'
     * @return string 'CC'
     */
    const VALUE_CC = 'CC';
    /**
     * Constant for value 'DD'
     * @return string 'DD'
     */
    const VALUE_DD = 'DD';
    /**
     * Constant for value 'INVOICE'
     * @return string 'INVOICE'
     */
    const VALUE_INVOICE = 'INVOICE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INV
     * @uses self::VALUE_CC
     * @uses self::VALUE_DD
     * @uses self::VALUE_INVOICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INV,
            self::VALUE_CC,
            self::VALUE_DD,
            self::VALUE_INVOICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
