<?php

namespace EnumType;

/**
 * This class stands for numberHeadingType EnumType
 * @subpackage Enumerations
 */
class NumberHeadingType
{
    /**
     * Constant for value 'ACN'
     * @return string 'ACN'
     */
    const VALUE_ACN = 'ACN';
    /**
     * Constant for value 'ARBN'
     * @return string 'ARBN'
     */
    const VALUE_ARBN = 'ARBN';
    /**
     * Constant for value 'ARSN'
     * @return string 'ARSN'
     */
    const VALUE_ARSN = 'ARSN';
    /**
     * Constant for value 'Number'
     * @return string 'Number'
     */
    const VALUE_NUMBER = 'Number';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACN
     * @uses self::VALUE_ARBN
     * @uses self::VALUE_ARSN
     * @uses self::VALUE_NUMBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACN,
            self::VALUE_ARBN,
            self::VALUE_ARSN,
            self::VALUE_NUMBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
