<?php

namespace EnumType;

/**
 * This class stands for bnStatusCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: APPL ReconsiderationDRGD DeregisteredEXPD ExpiringMCON Ministerial ConsentPEND Awaiting PaymentREGD RegisteredRJCT RejectedSNSD ReferredSOFF Strike Off
 * @subpackage Enumerations
 */
class BnStatusCodeType
{
    /**
     * Constant for value 'APPL'
     * @return string 'APPL'
     */
    const VALUE_APPL = 'APPL';
    /**
     * Constant for value 'EXPD'
     * @return string 'EXPD'
     */
    const VALUE_EXPD = 'EXPD';
    /**
     * Constant for value 'DRGD'
     * @return string 'DRGD'
     */
    const VALUE_DRGD = 'DRGD';
    /**
     * Constant for value 'MCON'
     * @return string 'MCON'
     */
    const VALUE_MCON = 'MCON';
    /**
     * Constant for value 'PEND'
     * @return string 'PEND'
     */
    const VALUE_PEND = 'PEND';
    /**
     * Constant for value 'REGD'
     * @return string 'REGD'
     */
    const VALUE_REGD = 'REGD';
    /**
     * Constant for value 'RJCT'
     * @return string 'RJCT'
     */
    const VALUE_RJCT = 'RJCT';
    /**
     * Constant for value 'SNSD'
     * @return string 'SNSD'
     */
    const VALUE_SNSD = 'SNSD';
    /**
     * Constant for value 'SOFF'
     * @return string 'SOFF'
     */
    const VALUE_SOFF = 'SOFF';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_APPL
     * @uses self::VALUE_EXPD
     * @uses self::VALUE_DRGD
     * @uses self::VALUE_MCON
     * @uses self::VALUE_PEND
     * @uses self::VALUE_REGD
     * @uses self::VALUE_RJCT
     * @uses self::VALUE_SNSD
     * @uses self::VALUE_SOFF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_APPL,
            self::VALUE_EXPD,
            self::VALUE_DRGD,
            self::VALUE_MCON,
            self::VALUE_PEND,
            self::VALUE_REGD,
            self::VALUE_RJCT,
            self::VALUE_SNSD,
            self::VALUE_SOFF,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
