<?php

namespace EnumType;

/**
 * This class stands for bnSearchStatusCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: DRGD DeregisteredPEND Pending PaymentREGD Registered
 * @subpackage Enumerations
 */
class BnSearchStatusCodeType
{
    /**
     * Constant for value 'DRGD'
     * @return string 'DRGD'
     */
    const VALUE_DRGD = 'DRGD';
    /**
     * Constant for value 'PEND'
     * @return string 'PEND'
     */
    const VALUE_PEND = 'PEND';
    /**
     * Constant for value 'REGD'
     * @return string 'REGD'
     */
    const VALUE_REGD = 'REGD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DRGD
     * @uses self::VALUE_PEND
     * @uses self::VALUE_REGD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DRGD,
            self::VALUE_PEND,
            self::VALUE_REGD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
