<?php

namespace EnumType;

/**
 * This class stands for bnRoleCodeType EnumType
 * @subpackage Enumerations
 */
class BnRoleCodeType
{
    /**
     * Constant for value 'GA'
     * @return string 'GA'
     */
    const VALUE_GA = 'GA';
    /**
     * Constant for value 'GB'
     * @return string 'GB'
     */
    const VALUE_GB = 'GB';
    /**
     * Constant for value 'GF'
     * @return string 'GF'
     */
    const VALUE_GF = 'GF';
    /**
     * Constant for value 'GG'
     * @return string 'GG'
     */
    const VALUE_GG = 'GG';
    /**
     * Constant for value 'GH'
     * @return string 'GH'
     */
    const VALUE_GH = 'GH';
    /**
     * Constant for value 'GI'
     * @return string 'GI'
     */
    const VALUE_GI = 'GI';
    /**
     * Constant for value 'GJ'
     * @return string 'GJ'
     */
    const VALUE_GJ = 'GJ';
    /**
     * Constant for value 'GK'
     * @return string 'GK'
     */
    const VALUE_GK = 'GK';
    /**
     * Constant for value 'GT'
     * @return string 'GT'
     */
    const VALUE_GT = 'GT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GA
     * @uses self::VALUE_GB
     * @uses self::VALUE_GF
     * @uses self::VALUE_GG
     * @uses self::VALUE_GH
     * @uses self::VALUE_GI
     * @uses self::VALUE_GJ
     * @uses self::VALUE_GK
     * @uses self::VALUE_GT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GA,
            self::VALUE_GB,
            self::VALUE_GF,
            self::VALUE_GG,
            self::VALUE_GH,
            self::VALUE_GI,
            self::VALUE_GJ,
            self::VALUE_GK,
            self::VALUE_GT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
