<?php

namespace EnumType;

/**
 * This class stands for bnApplicationStatusCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: APPL ReconsiderationMCON Ministerial ConsentPEND Awaiting PaymentSNSD Referredf
 * @subpackage Enumerations
 */
class BnApplicationStatusCodeType
{
    /**
     * Constant for value 'APPL'
     * @return string 'APPL'
     */
    const VALUE_APPL = 'APPL';
    /**
     * Constant for value 'MCON'
     * @return string 'MCON'
     */
    const VALUE_MCON = 'MCON';
    /**
     * Constant for value 'PEND'
     * @return string 'PEND'
     */
    const VALUE_PEND = 'PEND';
    /**
     * Constant for value 'SNSD'
     * @return string 'SNSD'
     */
    const VALUE_SNSD = 'SNSD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_APPL
     * @uses self::VALUE_MCON
     * @uses self::VALUE_PEND
     * @uses self::VALUE_SNSD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_APPL,
            self::VALUE_MCON,
            self::VALUE_PEND,
            self::VALUE_SNSD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
