<?php

namespace EnumType;

/**
 * This class stands for addressTypeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: RG Registered OfficeRP Registered Office in AustraliaPA Principal Place of BusinessRO Registered Address in Place of IncorporationGC Business Name Individual Residential AddressGD Business Name Principal Place of BusinessGE Business
 * Name Service of Notice AddressGL Business Name Contact Address
 * @subpackage Enumerations
 */
class AddressTypeType
{
    /**
     * Constant for value 'RG'
     * @return string 'RG'
     */
    const VALUE_RG = 'RG';
    /**
     * Constant for value 'RP'
     * @return string 'RP'
     */
    const VALUE_RP = 'RP';
    /**
     * Constant for value 'PA'
     * @return string 'PA'
     */
    const VALUE_PA = 'PA';
    /**
     * Constant for value 'RO'
     * @return string 'RO'
     */
    const VALUE_RO = 'RO';
    /**
     * Constant for value 'GC'
     * @return string 'GC'
     */
    const VALUE_GC = 'GC';
    /**
     * Constant for value 'GD'
     * @return string 'GD'
     */
    const VALUE_GD = 'GD';
    /**
     * Constant for value 'GE'
     * @return string 'GE'
     */
    const VALUE_GE = 'GE';
    /**
     * Constant for value 'GL'
     * @return string 'GL'
     */
    const VALUE_GL = 'GL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RG
     * @uses self::VALUE_RP
     * @uses self::VALUE_PA
     * @uses self::VALUE_RO
     * @uses self::VALUE_GC
     * @uses self::VALUE_GD
     * @uses self::VALUE_GE
     * @uses self::VALUE_GL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RG,
            self::VALUE_RP,
            self::VALUE_PA,
            self::VALUE_RO,
            self::VALUE_GC,
            self::VALUE_GD,
            self::VALUE_GE,
            self::VALUE_GL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
