<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for transactionsType StructType
 * @subpackage Structs
 */
class TransactionsType extends AbstractStructBase
{
    /**
     * The transaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\TransactionType[]
     */
    public $transaction;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - documentation: Total unpaid for current period | Special unsigned format for Qsp/PandD N15.2
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $total;
    /**
     * The dateDue
     * Meta informations extracted from the WSDL
     * - documentation: Use for currentUnpaid only
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateDue;
    /**
     * Constructor method for transactionsType
     * @uses TransactionsType::setTransaction()
     * @uses TransactionsType::setTotal()
     * @uses TransactionsType::setDateDue()
     * @param \StructType\TransactionType[] $transaction
     * @param float $total
     * @param string $dateDue
     */
    public function __construct(array $transaction = array(), $total = null, $dateDue = null)
    {
        $this
            ->setTransaction($transaction)
            ->setTotal($total)
            ->setDateDue($dateDue);
    }
    /**
     * Get transaction value
     * @return \StructType\TransactionType[]|null
     */
    public function getTransaction()
    {
        return $this->transaction;
    }
    /**
     * Set transaction value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionType[] $transaction
     * @return \StructType\TransactionsType
     */
    public function setTransaction(array $transaction = array())
    {
        foreach ($transaction as $transactionsTypeTransactionItem) {
            // validation for constraint: itemType
            if (!$transactionsTypeTransactionItem instanceof \StructType\TransactionType) {
                throw new \InvalidArgumentException(sprintf('The transaction property can only contain items of \StructType\TransactionType, "%s" given', is_object($transactionsTypeTransactionItem) ? get_class($transactionsTypeTransactionItem) : gettype($transactionsTypeTransactionItem)), __LINE__);
            }
        }
        $this->transaction = $transaction;
        return $this;
    }
    /**
     * Add item to transaction value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionType $item
     * @return \StructType\TransactionsType
     */
    public function addToTransaction(\StructType\TransactionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransactionType) {
            throw new \InvalidArgumentException(sprintf('The transaction property can only contain items of \StructType\TransactionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->transaction[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\TransactionsType
     */
    public function setTotal($total = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($total) && strlen(substr($total, strpos($total, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($total, strpos($total, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($total > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $total), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($total < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $total), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get dateDue value
     * @return string|null
     */
    public function getDateDue()
    {
        return $this->dateDue;
    }
    /**
     * Set dateDue value
     * @param string $dateDue
     * @return \StructType\TransactionsType
     */
    public function setDateDue($dateDue = null)
    {
        // validation for constraint: minInclusive
        if ($dateDue < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateDue), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateDue) && !is_string($dateDue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateDue)), __LINE__);
        }
        $this->dateDue = $dateDue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransactionsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
