<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for transactionType StructType
 * @subpackage Structs
 */
class TransactionType extends AbstractStructBase
{
    /**
     * The reportingParty
     * @var \StructType\FssAccountType
     */
    public $reportingParty;
    /**
     * The date
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $date;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The descriptionLine1
     * Meta informations extracted from the WSDL
     * - maxLength: 80
     * @var string
     */
    public $descriptionLine1;
    /**
     * The descriptionLine2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 80
     * @var string
     */
    public $descriptionLine2;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxLength: 40
     * @var string
     */
    public $reference;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - documentation: Special unsigned format for Qsp/PandD N15.2
     * - fractionDigits: 2
     * - maxInclusive: 999999999999999.99
     * - minInclusive: 0
     * @var float
     */
    public $amount;
    /**
     * Constructor method for transactionType
     * @uses TransactionType::setReportingParty()
     * @uses TransactionType::setDate()
     * @uses TransactionType::setCode()
     * @uses TransactionType::setDescriptionLine1()
     * @uses TransactionType::setDescriptionLine2()
     * @uses TransactionType::setReference()
     * @uses TransactionType::setAmount()
     * @param \StructType\FssAccountType $reportingParty
     * @param string $date
     * @param string $code
     * @param string $descriptionLine1
     * @param string $descriptionLine2
     * @param string $reference
     * @param float $amount
     */
    public function __construct(\StructType\FssAccountType $reportingParty = null, $date = null, $code = null, $descriptionLine1 = null, $descriptionLine2 = null, $reference = null, $amount = null)
    {
        $this
            ->setReportingParty($reportingParty)
            ->setDate($date)
            ->setCode($code)
            ->setDescriptionLine1($descriptionLine1)
            ->setDescriptionLine2($descriptionLine2)
            ->setReference($reference)
            ->setAmount($amount);
    }
    /**
     * Get reportingParty value
     * @return \StructType\FssAccountType|null
     */
    public function getReportingParty()
    {
        return $this->reportingParty;
    }
    /**
     * Set reportingParty value
     * @param \StructType\FssAccountType $reportingParty
     * @return \StructType\TransactionType
     */
    public function setReportingParty(\StructType\FssAccountType $reportingParty = null)
    {
        $this->reportingParty = $reportingParty;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\TransactionType
     */
    public function setDate($date = null)
    {
        // validation for constraint: minInclusive
        if ($date < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $date), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @uses \EnumType\Code::valueIsValid()
     * @uses \EnumType\Code::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\TransactionType
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Code::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $code, implode(', ', \EnumType\Code::getValidValues())), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get descriptionLine1 value
     * @return string|null
     */
    public function getDescriptionLine1()
    {
        return $this->descriptionLine1;
    }
    /**
     * Set descriptionLine1 value
     * @param string $descriptionLine1
     * @return \StructType\TransactionType
     */
    public function setDescriptionLine1($descriptionLine1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($descriptionLine1) && strlen($descriptionLine1) > 80) || (is_array($descriptionLine1) && count($descriptionLine1) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($descriptionLine1) ? strlen($descriptionLine1) : count($descriptionLine1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($descriptionLine1) && !is_string($descriptionLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptionLine1)), __LINE__);
        }
        $this->descriptionLine1 = $descriptionLine1;
        return $this;
    }
    /**
     * Get descriptionLine2 value
     * @return string|null
     */
    public function getDescriptionLine2()
    {
        return $this->descriptionLine2;
    }
    /**
     * Set descriptionLine2 value
     * @param string $descriptionLine2
     * @return \StructType\TransactionType
     */
    public function setDescriptionLine2($descriptionLine2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($descriptionLine2) && strlen($descriptionLine2) > 80) || (is_array($descriptionLine2) && count($descriptionLine2) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($descriptionLine2) ? strlen($descriptionLine2) : count($descriptionLine2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($descriptionLine2) && !is_string($descriptionLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptionLine2)), __LINE__);
        }
        $this->descriptionLine2 = $descriptionLine2;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\TransactionType
     */
    public function setReference($reference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($reference) && strlen($reference) > 40) || (is_array($reference) && count($reference) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($reference) ? strlen($reference) : count($reference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\TransactionType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($amount) && strlen(substr($amount, strpos($amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($amount, strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive
        if ($amount > 999999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 999999999999999, "%s" given', $amount), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $amount), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransactionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
