<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for traceType StructType
 * Meta informations extracted from the WSDL
 * - documentation: ~Internal~
 * @subpackage Structs
 */
class TraceType extends AbstractStructBase
{
    /**
     * The dateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateTime;
    /**
     * The source
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * @var string
     */
    public $source;
    /**
     * The text
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $text;
    /**
     * Constructor method for traceType
     * @uses TraceType::setDateTime()
     * @uses TraceType::setSource()
     * @uses TraceType::setText()
     * @param string $dateTime
     * @param string $source
     * @param string $text
     */
    public function __construct($dateTime = null, $source = null, $text = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setSource($source)
            ->setText($text);
    }
    /**
     * Get dateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->dateTime;
    }
    /**
     * Set dateTime value
     * @param string $dateTime
     * @return \StructType\TraceType
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTime)), __LINE__);
        }
        $this->dateTime = $dateTime;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\TraceType
     */
    public function setSource($source = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($source) && strlen($source) > 50) || (is_array($source) && count($source) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($source) ? strlen($source) : count($source)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\TraceType
     */
    public function setText($text = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($text) && strlen($text) > 200) || (is_array($text) && count($text) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($text) ? strlen($text) : count($text)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TraceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
