<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for telephoneNumberType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Telephone number
 * @subpackage Structs
 */
class TelephoneNumberType extends AbstractStructBase
{
    /**
     * The telephoneNumber
     * @var \StructType\TelephoneNumber
     */
    public $telephoneNumber;
    /**
     * The phoneType
     * @var string
     */
    public $phoneType;
    /**
     * Constructor method for telephoneNumberType
     * @uses TelephoneNumberType::setTelephoneNumber()
     * @uses TelephoneNumberType::setPhoneType()
     * @param \StructType\TelephoneNumber $telephoneNumber
     * @param string $phoneType
     */
    public function __construct(\StructType\TelephoneNumber $telephoneNumber = null, $phoneType = null)
    {
        $this
            ->setTelephoneNumber($telephoneNumber)
            ->setPhoneType($phoneType);
    }
    /**
     * Get telephoneNumber value
     * @return \StructType\TelephoneNumber|null
     */
    public function getTelephoneNumber()
    {
        return $this->telephoneNumber;
    }
    /**
     * Set telephoneNumber value
     * @param \StructType\TelephoneNumber $telephoneNumber
     * @return \StructType\TelephoneNumberType
     */
    public function setTelephoneNumber(\StructType\TelephoneNumber $telephoneNumber = null)
    {
        $this->telephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get phoneType value
     * @return string|null
     */
    public function getPhoneType()
    {
        return $this->phoneType;
    }
    /**
     * Set phoneType value
     * @uses \EnumType\PhoneType::valueIsValid()
     * @uses \EnumType\PhoneType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneType
     * @return \StructType\TelephoneNumberType
     */
    public function setPhoneType($phoneType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PhoneType::valueIsValid($phoneType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneType, implode(', ', \EnumType\PhoneType::getValidValues())), __LINE__);
        }
        $this->phoneType = $phoneType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TelephoneNumberType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
