<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for stateTerritory StructType
 * Meta informations extracted from the WSDL
 * - documentation: Details of previous registration by States and Territories before referral of powers to ASIC. | Identifier must be the state and state number
 * @subpackage Structs
 */
class StateTerritory extends AbstractStructBase
{
    /**
     * The previousStateNumber
     * Meta informations extracted from the WSDL
     * - maxLength: 20
     * @var string
     */
    public $previousStateNumber;
    /**
     * The issuingStateTerritory
     * @var string
     */
    public $issuingStateTerritory;
    /**
     * Constructor method for stateTerritory
     * @uses StateTerritory::setPreviousStateNumber()
     * @uses StateTerritory::setIssuingStateTerritory()
     * @param string $previousStateNumber
     * @param string $issuingStateTerritory
     */
    public function __construct($previousStateNumber = null, $issuingStateTerritory = null)
    {
        $this
            ->setPreviousStateNumber($previousStateNumber)
            ->setIssuingStateTerritory($issuingStateTerritory);
    }
    /**
     * Get previousStateNumber value
     * @return string|null
     */
    public function getPreviousStateNumber()
    {
        return $this->previousStateNumber;
    }
    /**
     * Set previousStateNumber value
     * @param string $previousStateNumber
     * @return \StructType\StateTerritory
     */
    public function setPreviousStateNumber($previousStateNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($previousStateNumber) && strlen($previousStateNumber) > 20) || (is_array($previousStateNumber) && count($previousStateNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($previousStateNumber) ? strlen($previousStateNumber) : count($previousStateNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($previousStateNumber) && !is_string($previousStateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($previousStateNumber)), __LINE__);
        }
        $this->previousStateNumber = $previousStateNumber;
        return $this;
    }
    /**
     * Get issuingStateTerritory value
     * @return string|null
     */
    public function getIssuingStateTerritory()
    {
        return $this->issuingStateTerritory;
    }
    /**
     * Set issuingStateTerritory value
     * @uses \EnumType\StateTerritoryCodeType::valueIsValid()
     * @uses \EnumType\StateTerritoryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $issuingStateTerritory
     * @return \StructType\StateTerritory
     */
    public function setIssuingStateTerritory($issuingStateTerritory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StateTerritoryCodeType::valueIsValid($issuingStateTerritory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $issuingStateTerritory, implode(', ', \EnumType\StateTerritoryCodeType::getValidValues())), __LINE__);
        }
        $this->issuingStateTerritory = $issuingStateTerritory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StateTerritory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
