<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for standardHeaderType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Standard message header for documents
 * @subpackage Structs
 */
class StandardHeaderType extends AbstractStructBase
{
    /**
     * The messageType
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $messageType;
    /**
     * The messageVersion
     * Meta informations extracted from the WSDL
     * - maxLength: 4
     * @var string
     */
    public $messageVersion;
    /**
     * The originatingChannel
     * @var string
     */
    public $originatingChannel;
    /**
     * The originatingService
     * @var string
     */
    public $originatingService;
    /**
     * The dateReceived
     * Meta informations extracted from the WSDL
     * - documentation: received date for Ascot fees assessment
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateReceived;
    /**
     * The timeReceived
     * Meta informations extracted from the WSDL
     * - documentation: received time for Ascot fees assessment
     * - minOccurs: 0
     * @var string
     */
    public $timeReceived;
    /**
     * The enteredByAsic
     * Meta informations extracted from the WSDL
     * - documentation: true indicates that this document was entered by ASIC staff
     * - minOccurs: 0
     * @var bool
     */
    public $enteredByAsic;
    /**
     * The dateCommenced
     * Meta informations extracted from the WSDL
     * - documentation: date creation of this document commenced
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateCommenced;
    /**
     * The timeCommenced
     * Meta informations extracted from the WSDL
     * - documentation: time creation of this document was commenced
     * - minOccurs: 0
     * @var string
     */
    public $timeCommenced;
    /**
     * The dateSubmitted
     * Meta informations extracted from the WSDL
     * - documentation: date this document was submitted to ASIC
     * - minOccurs: 0
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $dateSubmitted;
    /**
     * The timeSubmitted
     * Meta informations extracted from the WSDL
     * - documentation: time this document was submitted to ASIC
     * - minOccurs: 0
     * @var string
     */
    public $timeSubmitted;
    /**
     * Constructor method for standardHeaderType
     * @uses StandardHeaderType::setMessageType()
     * @uses StandardHeaderType::setMessageVersion()
     * @uses StandardHeaderType::setOriginatingChannel()
     * @uses StandardHeaderType::setOriginatingService()
     * @uses StandardHeaderType::setDateReceived()
     * @uses StandardHeaderType::setTimeReceived()
     * @uses StandardHeaderType::setEnteredByAsic()
     * @uses StandardHeaderType::setDateCommenced()
     * @uses StandardHeaderType::setTimeCommenced()
     * @uses StandardHeaderType::setDateSubmitted()
     * @uses StandardHeaderType::setTimeSubmitted()
     * @param string $messageType
     * @param string $messageVersion
     * @param string $originatingChannel
     * @param string $originatingService
     * @param string $dateReceived
     * @param string $timeReceived
     * @param bool $enteredByAsic
     * @param string $dateCommenced
     * @param string $timeCommenced
     * @param string $dateSubmitted
     * @param string $timeSubmitted
     */
    public function __construct($messageType = null, $messageVersion = null, $originatingChannel = null, $originatingService = null, $dateReceived = null, $timeReceived = null, $enteredByAsic = null, $dateCommenced = null, $timeCommenced = null, $dateSubmitted = null, $timeSubmitted = null)
    {
        $this
            ->setMessageType($messageType)
            ->setMessageVersion($messageVersion)
            ->setOriginatingChannel($originatingChannel)
            ->setOriginatingService($originatingService)
            ->setDateReceived($dateReceived)
            ->setTimeReceived($timeReceived)
            ->setEnteredByAsic($enteredByAsic)
            ->setDateCommenced($dateCommenced)
            ->setTimeCommenced($timeCommenced)
            ->setDateSubmitted($dateSubmitted)
            ->setTimeSubmitted($timeSubmitted);
    }
    /**
     * Get messageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->messageType;
    }
    /**
     * Set messageType value
     * @param string $messageType
     * @return \StructType\StandardHeaderType
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageType) && strlen($messageType) > 100) || (is_array($messageType) && count($messageType) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($messageType) ? strlen($messageType) : count($messageType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($messageType) && strlen($messageType) < 1) || (is_array($messageType) && count($messageType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageType) && !is_string($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageType)), __LINE__);
        }
        $this->messageType = $messageType;
        return $this;
    }
    /**
     * Get messageVersion value
     * @return string|null
     */
    public function getMessageVersion()
    {
        return $this->messageVersion;
    }
    /**
     * Set messageVersion value
     * @param string $messageVersion
     * @return \StructType\StandardHeaderType
     */
    public function setMessageVersion($messageVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageVersion) && strlen($messageVersion) > 4) || (is_array($messageVersion) && count($messageVersion) > 4)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4 element(s) or a scalar of 4 character(s) at most, "%d" length given', is_scalar($messageVersion) ? strlen($messageVersion) : count($messageVersion)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageVersion) && !is_string($messageVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageVersion)), __LINE__);
        }
        $this->messageVersion = $messageVersion;
        return $this;
    }
    /**
     * Get originatingChannel value
     * @return string|null
     */
    public function getOriginatingChannel()
    {
        return $this->originatingChannel;
    }
    /**
     * Set originatingChannel value
     * @uses \EnumType\OriginatingChannelType::valueIsValid()
     * @uses \EnumType\OriginatingChannelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $originatingChannel
     * @return \StructType\StandardHeaderType
     */
    public function setOriginatingChannel($originatingChannel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OriginatingChannelType::valueIsValid($originatingChannel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $originatingChannel, implode(', ', \EnumType\OriginatingChannelType::getValidValues())), __LINE__);
        }
        $this->originatingChannel = $originatingChannel;
        return $this;
    }
    /**
     * Get originatingService value
     * @return string|null
     */
    public function getOriginatingService()
    {
        return $this->originatingService;
    }
    /**
     * Set originatingService value
     * @uses \EnumType\OriginatingServiceType::valueIsValid()
     * @uses \EnumType\OriginatingServiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $originatingService
     * @return \StructType\StandardHeaderType
     */
    public function setOriginatingService($originatingService = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OriginatingServiceType::valueIsValid($originatingService)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $originatingService, implode(', ', \EnumType\OriginatingServiceType::getValidValues())), __LINE__);
        }
        $this->originatingService = $originatingService;
        return $this;
    }
    /**
     * Get dateReceived value
     * @return string|null
     */
    public function getDateReceived()
    {
        return $this->dateReceived;
    }
    /**
     * Set dateReceived value
     * @param string $dateReceived
     * @return \StructType\StandardHeaderType
     */
    public function setDateReceived($dateReceived = null)
    {
        // validation for constraint: minInclusive
        if ($dateReceived < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateReceived), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateReceived) && !is_string($dateReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateReceived)), __LINE__);
        }
        $this->dateReceived = $dateReceived;
        return $this;
    }
    /**
     * Get timeReceived value
     * @return string|null
     */
    public function getTimeReceived()
    {
        return $this->timeReceived;
    }
    /**
     * Set timeReceived value
     * @param string $timeReceived
     * @return \StructType\StandardHeaderType
     */
    public function setTimeReceived($timeReceived = null)
    {
        // validation for constraint: string
        if (!is_null($timeReceived) && !is_string($timeReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeReceived)), __LINE__);
        }
        $this->timeReceived = $timeReceived;
        return $this;
    }
    /**
     * Get enteredByAsic value
     * @return bool|null
     */
    public function getEnteredByAsic()
    {
        return $this->enteredByAsic;
    }
    /**
     * Set enteredByAsic value
     * @param bool $enteredByAsic
     * @return \StructType\StandardHeaderType
     */
    public function setEnteredByAsic($enteredByAsic = null)
    {
        // validation for constraint: boolean
        if (!is_null($enteredByAsic) && !is_bool($enteredByAsic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enteredByAsic)), __LINE__);
        }
        $this->enteredByAsic = $enteredByAsic;
        return $this;
    }
    /**
     * Get dateCommenced value
     * @return string|null
     */
    public function getDateCommenced()
    {
        return $this->dateCommenced;
    }
    /**
     * Set dateCommenced value
     * @param string $dateCommenced
     * @return \StructType\StandardHeaderType
     */
    public function setDateCommenced($dateCommenced = null)
    {
        // validation for constraint: minInclusive
        if ($dateCommenced < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateCommenced), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateCommenced) && !is_string($dateCommenced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateCommenced)), __LINE__);
        }
        $this->dateCommenced = $dateCommenced;
        return $this;
    }
    /**
     * Get timeCommenced value
     * @return string|null
     */
    public function getTimeCommenced()
    {
        return $this->timeCommenced;
    }
    /**
     * Set timeCommenced value
     * @param string $timeCommenced
     * @return \StructType\StandardHeaderType
     */
    public function setTimeCommenced($timeCommenced = null)
    {
        // validation for constraint: string
        if (!is_null($timeCommenced) && !is_string($timeCommenced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeCommenced)), __LINE__);
        }
        $this->timeCommenced = $timeCommenced;
        return $this;
    }
    /**
     * Get dateSubmitted value
     * @return string|null
     */
    public function getDateSubmitted()
    {
        return $this->dateSubmitted;
    }
    /**
     * Set dateSubmitted value
     * @param string $dateSubmitted
     * @return \StructType\StandardHeaderType
     */
    public function setDateSubmitted($dateSubmitted = null)
    {
        // validation for constraint: minInclusive
        if ($dateSubmitted < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $dateSubmitted), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateSubmitted) && !is_string($dateSubmitted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateSubmitted)), __LINE__);
        }
        $this->dateSubmitted = $dateSubmitted;
        return $this;
    }
    /**
     * Get timeSubmitted value
     * @return string|null
     */
    public function getTimeSubmitted()
    {
        return $this->timeSubmitted;
    }
    /**
     * Set timeSubmitted value
     * @param string $timeSubmitted
     * @return \StructType\StandardHeaderType
     */
    public function setTimeSubmitted($timeSubmitted = null)
    {
        // validation for constraint: string
        if (!is_null($timeSubmitted) && !is_string($timeSubmitted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeSubmitted)), __LINE__);
        }
        $this->timeSubmitted = $timeSubmitted;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StandardHeaderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
