<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for softwareInformationType StructType
 * @subpackage Structs
 */
class SoftwareInformationType extends AbstractStructBase
{
    /**
     * The organisationalName
     * Meta informations extracted from the WSDL
     * - documentation: Client provided identifier of client software version
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $organisationalName;
    /**
     * The productName
     * Meta informations extracted from the WSDL
     * - documentation: Client provided identifier of client software version
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $productName;
    /**
     * The productVersion
     * Meta informations extracted from the WSDL
     * - documentation: Client provided identifier of client software version
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $productVersion;
    /**
     * Constructor method for softwareInformationType
     * @uses SoftwareInformationType::setOrganisationalName()
     * @uses SoftwareInformationType::setProductName()
     * @uses SoftwareInformationType::setProductVersion()
     * @param string $organisationalName
     * @param string $productName
     * @param string $productVersion
     */
    public function __construct($organisationalName = null, $productName = null, $productVersion = null)
    {
        $this
            ->setOrganisationalName($organisationalName)
            ->setProductName($productName)
            ->setProductVersion($productVersion);
    }
    /**
     * Get organisationalName value
     * @return string|null
     */
    public function getOrganisationalName()
    {
        return $this->organisationalName;
    }
    /**
     * Set organisationalName value
     * @param string $organisationalName
     * @return \StructType\SoftwareInformationType
     */
    public function setOrganisationalName($organisationalName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organisationalName) && strlen($organisationalName) > 100) || (is_array($organisationalName) && count($organisationalName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($organisationalName) ? strlen($organisationalName) : count($organisationalName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organisationalName) && strlen($organisationalName) < 1) || (is_array($organisationalName) && count($organisationalName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organisationalName) && !is_string($organisationalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisationalName)), __LINE__);
        }
        $this->organisationalName = $organisationalName;
        return $this;
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \StructType\SoftwareInformationType
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($productName) && strlen($productName) > 100) || (is_array($productName) && count($productName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($productName) ? strlen($productName) : count($productName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($productName) && strlen($productName) < 1) || (is_array($productName) && count($productName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get productVersion value
     * @return string|null
     */
    public function getProductVersion()
    {
        return $this->productVersion;
    }
    /**
     * Set productVersion value
     * @param string $productVersion
     * @return \StructType\SoftwareInformationType
     */
    public function setProductVersion($productVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($productVersion) && strlen($productVersion) > 100) || (is_array($productVersion) && count($productVersion) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($productVersion) ? strlen($productVersion) : count($productVersion)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($productVersion) && strlen($productVersion) < 1) || (is_array($productVersion) && count($productVersion) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($productVersion) && !is_string($productVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productVersion)), __LINE__);
        }
        $this->productVersion = $productVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SoftwareInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
