<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for simpleBnExtractType StructType
 * @subpackage Structs
 */
class SimpleBnExtractType extends AbstractStructBase
{
    /**
     * The business
     * @var \StructType\BusinessEntityType
     */
    public $business;
    /**
     * The businessName
     * @var \StructType\OutboundBusinessNameType
     */
    public $businessName;
    /**
     * Constructor method for simpleBnExtractType
     * @uses SimpleBnExtractType::setBusiness()
     * @uses SimpleBnExtractType::setBusinessName()
     * @param \StructType\BusinessEntityType $business
     * @param \StructType\OutboundBusinessNameType $businessName
     */
    public function __construct(\StructType\BusinessEntityType $business = null, \StructType\OutboundBusinessNameType $businessName = null)
    {
        $this
            ->setBusiness($business)
            ->setBusinessName($businessName);
    }
    /**
     * Get business value
     * @return \StructType\BusinessEntityType|null
     */
    public function getBusiness()
    {
        return $this->business;
    }
    /**
     * Set business value
     * @param \StructType\BusinessEntityType $business
     * @return \StructType\SimpleBnExtractType
     */
    public function setBusiness(\StructType\BusinessEntityType $business = null)
    {
        $this->business = $business;
        return $this;
    }
    /**
     * Get businessName value
     * @return \StructType\OutboundBusinessNameType|null
     */
    public function getBusinessName()
    {
        return $this->businessName;
    }
    /**
     * Set businessName value
     * @param \StructType\OutboundBusinessNameType $businessName
     * @return \StructType\SimpleBnExtractType
     */
    public function setBusinessName(\StructType\OutboundBusinessNameType $businessName = null)
    {
        $this->businessName = $businessName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SimpleBnExtractType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
