<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchIdentifierType StructType
 * @subpackage Structs
 */
class SearchIdentifierType extends AbstractStructBase
{
    /**
     * The identifierType
     * Meta informations extracted from the WSDL
     * - documentation: The identifierType stores the type of identifier e.g. ABN, ACN.
     * - maxLength: 6
     * @var string
     */
    public $identifierType;
    /**
     * The identifierValue
     * Meta informations extracted from the WSDL
     * - documentation: The identifierValue stores the value of the identifier.
     * - maxLength: 20
     * @var string
     */
    public $identifierValue;
    /**
     * The date
     * Meta informations extracted from the WSDL
     * - documentation: The date defines the date of records overwhich the search should be made. The format of the date must be ‘yyyy-mm-dd’.
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The history
     * Meta informations extracted from the WSDL
     * - documentation: The history defines whether the record's history is required to be returned in the result.
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $history;
    /**
     * Constructor method for searchIdentifierType
     * @uses SearchIdentifierType::setIdentifierType()
     * @uses SearchIdentifierType::setIdentifierValue()
     * @uses SearchIdentifierType::setDate()
     * @uses SearchIdentifierType::setHistory()
     * @param string $identifierType
     * @param string $identifierValue
     * @param string $date
     * @param string $history
     */
    public function __construct($identifierType = null, $identifierValue = null, $date = null, $history = null)
    {
        $this
            ->setIdentifierType($identifierType)
            ->setIdentifierValue($identifierValue)
            ->setDate($date)
            ->setHistory($history);
    }
    /**
     * Get identifierType value
     * @return string|null
     */
    public function getIdentifierType()
    {
        return $this->identifierType;
    }
    /**
     * Set identifierType value
     * @param string $identifierType
     * @return \StructType\SearchIdentifierType
     */
    public function setIdentifierType($identifierType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identifierType) && strlen($identifierType) > 6) || (is_array($identifierType) && count($identifierType) > 6)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s) at most, "%d" length given', is_scalar($identifierType) ? strlen($identifierType) : count($identifierType)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identifierType) && !is_string($identifierType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifierType)), __LINE__);
        }
        $this->identifierType = $identifierType;
        return $this;
    }
    /**
     * Get identifierValue value
     * @return string|null
     */
    public function getIdentifierValue()
    {
        return $this->identifierValue;
    }
    /**
     * Set identifierValue value
     * @param string $identifierValue
     * @return \StructType\SearchIdentifierType
     */
    public function setIdentifierValue($identifierValue = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identifierValue) && strlen($identifierValue) > 20) || (is_array($identifierValue) && count($identifierValue) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($identifierValue) ? strlen($identifierValue) : count($identifierValue)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identifierValue) && !is_string($identifierValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifierValue)), __LINE__);
        }
        $this->identifierValue = $identifierValue;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\SearchIdentifierType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get history value
     * @return string|null
     */
    public function getHistory()
    {
        return $this->history;
    }
    /**
     * Set history value
     * @param string $history
     * @return \StructType\SearchIdentifierType
     */
    public function setHistory($history = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($history) && strlen($history) > 1) || (is_array($history) && count($history) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($history) ? strlen($history) : count($history)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($history) && !is_string($history)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($history)), __LINE__);
        }
        $this->history = $history;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchIdentifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
