<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for search StructType
 * @subpackage Structs
 */
class Search extends AbstractStructBase
{
    /**
     * The abn
     * Meta informations extracted from the WSDL
     * - documentation: Abn for business name organisation holder | ABN as 99999999999
     * - maxLength: 11
     * - minLength: 11
     * - pattern: ([0-9]{11})
     * @var string
     */
    public $abn;
    /**
     * The orgNumber
     * Meta informations extracted from the WSDL
     * - documentation: Asic identifier for business name organisation holder
     * @var string
     */
    public $orgNumber;
    /**
     * The nniNumber
     * Meta informations extracted from the WSDL
     * - documentation: Asic identifier for business name
     * @var string
     */
    public $nniNumber;
    /**
     * The organisation
     * @var \StructType\Organisation
     */
    public $organisation;
    /**
     * The previousStateOrTerritory
     * @var \StructType\PreviousStateTerritoryType
     */
    public $previousStateOrTerritory;
    /**
     * The bnReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $bnReferenceNumber;
    /**
     * Constructor method for search
     * @uses Search::setAbn()
     * @uses Search::setOrgNumber()
     * @uses Search::setNniNumber()
     * @uses Search::setOrganisation()
     * @uses Search::setPreviousStateOrTerritory()
     * @uses Search::setBnReferenceNumber()
     * @param string $abn
     * @param string $orgNumber
     * @param string $nniNumber
     * @param \StructType\Organisation $organisation
     * @param \StructType\PreviousStateTerritoryType $previousStateOrTerritory
     * @param string $bnReferenceNumber
     */
    public function __construct($abn = null, $orgNumber = null, $nniNumber = null, \StructType\Organisation $organisation = null, \StructType\PreviousStateTerritoryType $previousStateOrTerritory = null, $bnReferenceNumber = null)
    {
        $this
            ->setAbn($abn)
            ->setOrgNumber($orgNumber)
            ->setNniNumber($nniNumber)
            ->setOrganisation($organisation)
            ->setPreviousStateOrTerritory($previousStateOrTerritory)
            ->setBnReferenceNumber($bnReferenceNumber);
    }
    /**
     * Get abn value
     * @return string|null
     */
    public function getAbn()
    {
        return $this->abn;
    }
    /**
     * Set abn value
     * @param string $abn
     * @return \StructType\Search
     */
    public function setAbn($abn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abn) && strlen($abn) > 11) || (is_array($abn) && count($abn) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($abn) ? strlen($abn) : count($abn)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($abn) && strlen($abn) < 11) || (is_array($abn) && count($abn) < 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($abn) && !preg_match('/([0-9]{11})/', $abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{11})", "%s" given', var_export($abn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abn) && !is_string($abn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abn)), __LINE__);
        }
        $this->abn = $abn;
        return $this;
    }
    /**
     * Get orgNumber value
     * @return string|null
     */
    public function getOrgNumber()
    {
        return $this->orgNumber;
    }
    /**
     * Set orgNumber value
     * @param string $orgNumber
     * @return \StructType\Search
     */
    public function setOrgNumber($orgNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orgNumber) && !is_string($orgNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgNumber)), __LINE__);
        }
        $this->orgNumber = $orgNumber;
        return $this;
    }
    /**
     * Get nniNumber value
     * @return string|null
     */
    public function getNniNumber()
    {
        return $this->nniNumber;
    }
    /**
     * Set nniNumber value
     * @param string $nniNumber
     * @return \StructType\Search
     */
    public function setNniNumber($nniNumber = null)
    {
        // validation for constraint: string
        if (!is_null($nniNumber) && !is_string($nniNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nniNumber)), __LINE__);
        }
        $this->nniNumber = $nniNumber;
        return $this;
    }
    /**
     * Get organisation value
     * @return \StructType\Organisation|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param \StructType\Organisation $organisation
     * @return \StructType\Search
     */
    public function setOrganisation(\StructType\Organisation $organisation = null)
    {
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get previousStateOrTerritory value
     * @return \StructType\PreviousStateTerritoryType|null
     */
    public function getPreviousStateOrTerritory()
    {
        return $this->previousStateOrTerritory;
    }
    /**
     * Set previousStateOrTerritory value
     * @param \StructType\PreviousStateTerritoryType $previousStateOrTerritory
     * @return \StructType\Search
     */
    public function setPreviousStateOrTerritory(\StructType\PreviousStateTerritoryType $previousStateOrTerritory = null)
    {
        $this->previousStateOrTerritory = $previousStateOrTerritory;
        return $this;
    }
    /**
     * Get bnReferenceNumber value
     * @return string|null
     */
    public function getBnReferenceNumber()
    {
        return $this->bnReferenceNumber;
    }
    /**
     * Set bnReferenceNumber value
     * @param string $bnReferenceNumber
     * @return \StructType\Search
     */
    public function setBnReferenceNumber($bnReferenceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bnReferenceNumber) && strlen($bnReferenceNumber) > 20) || (is_array($bnReferenceNumber) && count($bnReferenceNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($bnReferenceNumber) ? strlen($bnReferenceNumber) : count($bnReferenceNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bnReferenceNumber) && strlen($bnReferenceNumber) < 1) || (is_array($bnReferenceNumber) && count($bnReferenceNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bnReferenceNumber) && !is_string($bnReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bnReferenceNumber)), __LINE__);
        }
        $this->bnReferenceNumber = $bnReferenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Search
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
