<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for result StructType
 * @subpackage Structs
 */
class Result extends AbstractStructBase
{
    /**
     * The requestFulfilled
     * Meta informations extracted from the WSDL
     * - documentation: The request was completed and accepted. Results are included in the reply.
     * - pattern: true
     * @var bool
     */
    public $requestFulfilled;
    /**
     * The requestRejected
     * Meta informations extracted from the WSDL
     * - documentation: The request was completed and rejected. Reasons are included in the reply.
     * - pattern: true
     * @var bool
     */
    public $requestRejected;
    /**
     * The requestDelayed
     * Meta informations extracted from the WSDL
     * - documentation: The request was not completed. The means to determine the final result are message specific.
     * - pattern: true
     * @var bool
     */
    public $requestDelayed;
    /**
     * The requestFailed
     * Meta informations extracted from the WSDL
     * - documentation: The request could not be processed due to processing errors. Reasons are included in the reply
     * - pattern: true
     * @var bool
     */
    public $requestFailed;
    /**
     * Constructor method for result
     * @uses Result::setRequestFulfilled()
     * @uses Result::setRequestRejected()
     * @uses Result::setRequestDelayed()
     * @uses Result::setRequestFailed()
     * @param bool $requestFulfilled
     * @param bool $requestRejected
     * @param bool $requestDelayed
     * @param bool $requestFailed
     */
    public function __construct($requestFulfilled = null, $requestRejected = null, $requestDelayed = null, $requestFailed = null)
    {
        $this
            ->setRequestFulfilled($requestFulfilled)
            ->setRequestRejected($requestRejected)
            ->setRequestDelayed($requestDelayed)
            ->setRequestFailed($requestFailed);
    }
    /**
     * Get requestFulfilled value
     * @return bool|null
     */
    public function getRequestFulfilled()
    {
        return $this->requestFulfilled;
    }
    /**
     * Set requestFulfilled value
     * @param bool $requestFulfilled
     * @return \StructType\Result
     */
    public function setRequestFulfilled($requestFulfilled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requestFulfilled) && !preg_match('/true/', $requestFulfilled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($requestFulfilled, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($requestFulfilled) && !is_bool($requestFulfilled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requestFulfilled)), __LINE__);
        }
        $this->requestFulfilled = $requestFulfilled;
        return $this;
    }
    /**
     * Get requestRejected value
     * @return bool|null
     */
    public function getRequestRejected()
    {
        return $this->requestRejected;
    }
    /**
     * Set requestRejected value
     * @param bool $requestRejected
     * @return \StructType\Result
     */
    public function setRequestRejected($requestRejected = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requestRejected) && !preg_match('/true/', $requestRejected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($requestRejected, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($requestRejected) && !is_bool($requestRejected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requestRejected)), __LINE__);
        }
        $this->requestRejected = $requestRejected;
        return $this;
    }
    /**
     * Get requestDelayed value
     * @return bool|null
     */
    public function getRequestDelayed()
    {
        return $this->requestDelayed;
    }
    /**
     * Set requestDelayed value
     * @param bool $requestDelayed
     * @return \StructType\Result
     */
    public function setRequestDelayed($requestDelayed = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requestDelayed) && !preg_match('/true/', $requestDelayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($requestDelayed, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($requestDelayed) && !is_bool($requestDelayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requestDelayed)), __LINE__);
        }
        $this->requestDelayed = $requestDelayed;
        return $this;
    }
    /**
     * Get requestFailed value
     * @return bool|null
     */
    public function getRequestFailed()
    {
        return $this->requestFailed;
    }
    /**
     * Set requestFailed value
     * @param bool $requestFailed
     * @return \StructType\Result
     */
    public function setRequestFailed($requestFailed = null)
    {
        // validation for constraint: pattern
        if (is_scalar($requestFailed) && !preg_match('/true/', $requestFailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($requestFailed, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($requestFailed) && !is_bool($requestFailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requestFailed)), __LINE__);
        }
        $this->requestFailed = $requestFailed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Result
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
