<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for requestRejectedType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This is for reporting business problems with the data, details of which are to be shown to the user. See requestFailureType for reporting an internal, system or infrastructure failure
 * @subpackage Structs
 */
class RequestRejectedType extends AbstractStructBase
{
    /**
     * The rejected
     * Meta informations extracted from the WSDL
     * - documentation: restricted by pattern to true. Reasons provided in exceptionList
     * - pattern: true
     * @var bool
     */
    public $rejected;
    /**
     * Constructor method for requestRejectedType
     * @uses RequestRejectedType::setRejected()
     * @param bool $rejected
     */
    public function __construct($rejected = null)
    {
        $this
            ->setRejected($rejected);
    }
    /**
     * Get rejected value
     * @return bool|null
     */
    public function getRejected()
    {
        return $this->rejected;
    }
    /**
     * Set rejected value
     * @param bool $rejected
     * @return \StructType\RequestRejectedType
     */
    public function setRejected($rejected = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rejected) && !preg_match('/true/', $rejected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($rejected, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($rejected) && !is_bool($rejected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($rejected)), __LINE__);
        }
        $this->rejected = $rejected;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestRejectedType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
