<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for requestFailedType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This is for reporting an internal, system or infrastructure failure e.g. when an enquiry message hits a problem in response to a transactional service request. See requestRejectType for reporting business problems with the data.
 * @subpackage Structs
 */
class RequestFailedType extends AbstractStructBase
{
    /**
     * The transient
     * Meta informations extracted from the WSDL
     * - documentation: Message encountered a transient failure and can be retried (restricted by pattern to true). Reasons provided in exceptionList
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $transient;
    /**
     * The permanent
     * Meta informations extracted from the WSDL
     * - documentation: Message is deemed to be permanently failed (restricted by pattern to true). Reasons provided in exceptionList
     * - minOccurs: 0
     * - pattern: true
     * @var bool
     */
    public $permanent;
    /**
     * Constructor method for requestFailedType
     * @uses RequestFailedType::setTransient()
     * @uses RequestFailedType::setPermanent()
     * @param bool $transient
     * @param bool $permanent
     */
    public function __construct($transient = null, $permanent = null)
    {
        $this
            ->setTransient($transient)
            ->setPermanent($permanent);
    }
    /**
     * Get transient value
     * @return bool|null
     */
    public function getTransient()
    {
        return $this->transient;
    }
    /**
     * Set transient value
     * @param bool $transient
     * @return \StructType\RequestFailedType
     */
    public function setTransient($transient = null)
    {
        // validation for constraint: pattern
        if (is_scalar($transient) && !preg_match('/true/', $transient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($transient, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($transient) && !is_bool($transient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($transient)), __LINE__);
        }
        $this->transient = $transient;
        return $this;
    }
    /**
     * Get permanent value
     * @return bool|null
     */
    public function getPermanent()
    {
        return $this->permanent;
    }
    /**
     * Set permanent value
     * @param bool $permanent
     * @return \StructType\RequestFailedType
     */
    public function setPermanent($permanent = null)
    {
        // validation for constraint: pattern
        if (is_scalar($permanent) && !preg_match('/true/', $permanent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "true", "%s" given', var_export($permanent, true)), __LINE__);
        }
        // validation for constraint: boolean
        if (!is_null($permanent) && !is_bool($permanent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($permanent)), __LINE__);
        }
        $this->permanent = $permanent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestFailedType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
