<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reportDataType StructType
 * @subpackage Structs
 */
class ReportDataType extends AbstractStructBase
{
    /**
     * The reportIdentifier
     * Meta informations extracted from the WSDL
     * - maxInclusive: 99999999999
     * - minInclusive: 1
     * @var int
     */
    public $reportIdentifier;
    /**
     * The reportType
     * @var string
     */
    public $reportType;
    /**
     * The createDate
     * Meta informations extracted from the WSDL
     * - base: xs:date
     * - minInclusive: 1582-01-02
     * @var string
     */
    public $createDate;
    /**
     * The reportPeriod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PeriodType
     */
    public $reportPeriod;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The reportSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $reportSize;
    /**
     * Constructor method for reportDataType
     * @uses ReportDataType::setReportIdentifier()
     * @uses ReportDataType::setReportType()
     * @uses ReportDataType::setCreateDate()
     * @uses ReportDataType::setReportPeriod()
     * @uses ReportDataType::setState()
     * @uses ReportDataType::setReportSize()
     * @param int $reportIdentifier
     * @param string $reportType
     * @param string $createDate
     * @param \StructType\PeriodType $reportPeriod
     * @param string $state
     * @param int $reportSize
     */
    public function __construct($reportIdentifier = null, $reportType = null, $createDate = null, \StructType\PeriodType $reportPeriod = null, $state = null, $reportSize = null)
    {
        $this
            ->setReportIdentifier($reportIdentifier)
            ->setReportType($reportType)
            ->setCreateDate($createDate)
            ->setReportPeriod($reportPeriod)
            ->setState($state)
            ->setReportSize($reportSize);
    }
    /**
     * Get reportIdentifier value
     * @return int|null
     */
    public function getReportIdentifier()
    {
        return $this->reportIdentifier;
    }
    /**
     * Set reportIdentifier value
     * @param int $reportIdentifier
     * @return \StructType\ReportDataType
     */
    public function setReportIdentifier($reportIdentifier = null)
    {
        // validation for constraint: maxInclusive
        if ($reportIdentifier > 99999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 99999999999, "%s" given', $reportIdentifier), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($reportIdentifier < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $reportIdentifier), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($reportIdentifier) && !is_numeric($reportIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reportIdentifier)), __LINE__);
        }
        $this->reportIdentifier = $reportIdentifier;
        return $this;
    }
    /**
     * Get reportType value
     * @return string|null
     */
    public function getReportType()
    {
        return $this->reportType;
    }
    /**
     * Set reportType value
     * @uses \EnumType\BnReportType::valueIsValid()
     * @uses \EnumType\BnReportType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reportType
     * @return \StructType\ReportDataType
     */
    public function setReportType($reportType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BnReportType::valueIsValid($reportType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reportType, implode(', ', \EnumType\BnReportType::getValidValues())), __LINE__);
        }
        $this->reportType = $reportType;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\ReportDataType
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: minInclusive
        if ($createDate < 1582) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1582, "%s" given', $createDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get reportPeriod value
     * @return \StructType\PeriodType|null
     */
    public function getReportPeriod()
    {
        return $this->reportPeriod;
    }
    /**
     * Set reportPeriod value
     * @param \StructType\PeriodType $reportPeriod
     * @return \StructType\ReportDataType
     */
    public function setReportPeriod(\StructType\PeriodType $reportPeriod = null)
    {
        $this->reportPeriod = $reportPeriod;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \EnumType\StateTerritoryCodeType::valueIsValid()
     * @uses \EnumType\StateTerritoryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\ReportDataType
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StateTerritoryCodeType::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \EnumType\StateTerritoryCodeType::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get reportSize value
     * @return int|null
     */
    public function getReportSize()
    {
        return $this->reportSize;
    }
    /**
     * Set reportSize value
     * @param int $reportSize
     * @return \StructType\ReportDataType
     */
    public function setReportSize($reportSize = null)
    {
        // validation for constraint: int
        if (!is_null($reportSize) && !is_numeric($reportSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reportSize)), __LINE__);
        }
        $this->reportSize = $reportSize;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
